﻿---
title: Configure modules
description: Filebeat modules provide a quick way to get started processing common log formats. They contain default configurations, Elasticsearch ingest pipeline...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-modules
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure modules
<note>
  Using Filebeat modules is optional. You may decide to [configure inputs manually](https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-options) if you’re using a log type that isn’t supported, or you want to use a different setup.
</note>

Filebeat [modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules) provide a quick way to get started processing common log formats. They contain default configurations, Elasticsearch ingest pipeline definitions, and Kibana dashboards to help you implement and deploy a log monitoring solution.
You can configure modules in the `modules.d` directory (recommended), or in the Filebeat configuration file.
Before running Filebeat with modules enabled, make sure you also set up the environment to use Kibana dashboards. See [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration) for more information.
<note>
  On systems with POSIX file permissions, all Beats configuration files are subject to ownership and file permission checks. For more information, see [Config File Ownership and Permissions](https://www.elastic.co/docs/reference/beats/libbeat/config-file-permissions).
</note>


## Configure modules in the `modules.d` directory

The `modules.d` directory contains default configurations for all the modules available in Filebeat. To enable or disable specific module configurations under `modules.d`, run the [`modules enable` or `modules disable`](/docs/reference/beats/filebeat/command-line-options#modules-command) command. For example:
<tab-set>
  <tab-item title="DEB">
    ```sh
    filebeat modules enable nginx
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    filebeat modules enable nginx
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./filebeat modules enable nginx
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./filebeat modules enable nginx
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS > .\filebeat.exe modules enable nginx
    ```
  </tab-item>
</tab-set>

The default configurations assume that your data is in the location expected for your OS and that the behavior of the module is appropriate for your environment. To change the default behavior, configure variable settings. For a list of available settings, see the documentation under [Modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules).
For advanced use cases, you can also [override input settings](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings).
<tip>
  You can enable modules at runtime by using the [--modules flag](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules). This is useful if you’re getting started and want to try things out. Any modules specified at the command line are loaded along with any modules that are enabled in the configuration file or `modules.d` directory. If there’s a conflict, the configuration specified at the command line is used.
</tip>


## Configure modules in the `filebeat.yml` file

When possible, you should use the config files in the `modules.d` directory.
However, configuring [modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules) directly in the config file is a practical approach if you have upgraded from a previous version of Filebeat and don’t want to move your module configs to the `modules.d` directory. You can continue to configure modules in the `filebeat.yml` file, but you won’t be able to use the `modules` command to enable and disable configurations because the command requires the `modules.d` layout.
To enable specific modules in the `filebeat.yml` config file, add entries to the `filebeat.modules` list. Each entry in the list begins with a dash (-) and is followed by settings for that module.
The following example shows a configuration that runs the `nginx`,`mysql`, and `system` modules:
```yaml
filebeat.modules:
- module: nginx
  access:
  error:
- module: mysql
  slowlog:
- module: system
  auth:
```