﻿---
title: Configure feature flags
description: The Feature Flags section of the filebeat.yml config file contains settings in Filebeat that are disabled by default. These may include experimental features,...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuration-feature-flags
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure feature flags
The Feature Flags section of the `filebeat.yml` config file contains settings in Filebeat that are disabled by default. These may include experimental features, changes to behaviors within Filebeat, or settings that could cause a breaking change. For example a setting that changes information included in events might be inconsistent with the naming pattern expected in your configured Filebeat output.
To enable any of the settings listed on this page, change the associated `enabled` flag from `false` to `true`.
```yaml
features:
  mysetting:
    enabled: true
```


## Configuration options

You can specify the following options in the `features` section of the `filebeat.yml` config file:

### `fqdn`

Contains configuration for the FQDN reporting feature. When this feature is enabled, the fully-qualified domain name for the host is reported in the `host.name` field in events produced by Filebeat.
<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

For FQDN reporting to work as expected, the hostname of the current host must either:
- Have a CNAME entry defined in DNS.
- Have one of its corresponding IP addresses respond successfully to a reverse DNS lookup.

If neither pre-requisite is satisfied, `host.name` continues to report the hostname of the current host as if the FQDN feature flag were not enabled.
Example configuration:
```yaml
features:
  fqdn:
    enabled: true
```


#### `enabled`

Set to `true` to enable the FQDN reporting feature of Filebeat. Defaults to `false`.