﻿---
title: Advanced usage
description: Appenders allow users to append configuration that is already built with the help of either templates or builders. Appenders can be configured to be applied...
url: https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover-advanced
products:
  - Beats
  - Filebeat
applies_to:
  - Elastic Stack: Generally available
---

# Advanced usage
<warning>
  If you still have `log`  or `container` inputs in your autodiscover templates please follow [our official guide](https://www.elastic.co/docs/reference/beats/filebeat/migrate-to-filestream) to migrate existing `log` inputs to `filestream` inputs.The `log` input is deprecated in version 7.16 and disabled in version 9.0.
</warning>


## Appenders

Appenders allow users to append configuration that is already built with the help of either templates or builders. Appenders can be configured to be applied only when a required condition is matched. The kind of configuration that is applied is specific to each appender.

### Config

The config appender can apply a config on top of the config that was generated by templates or builders. The config is applied whenever a provided condition is matched. It is always applied if there is no condition provided.
```yaml
filebeat.autodiscover:
  providers:
    - type: kubernetes
      templates:
        ...
      appenders:
        - type: config
          condition.equals:
            kubernetes.namespace: "prometheus"
          config:
            fields:
              type: monitoring
```