﻿---
title: Configure the Redis output
description: The Redis output inserts the events into a Redis list or a Redis channel. This output plugin is compatible with the Redis input plugin for Logstash. To...
url: https://www.elastic.co/docs/reference/beats/auditbeat/redis-output
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Redis output
The Redis output inserts the events into a Redis list or a Redis channel. This output plugin is compatible with the [Redis input plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-redis) for Logstash.
To use this output, edit the Auditbeat configuration file to disable the Elasticsearch output by commenting it out, and enable the Redis output by adding `output.redis`.
Example configuration:
```yaml
output.redis:
  hosts: ["localhost"]
  password: "my_password"
  key: "auditbeat"
  db: 0
  timeout: 5
```


## Compatibility

This output is expected to work with all Redis versions between 3.2.4 and 5.0.8. Other versions might work as well, but are not supported.

## Configuration options

You can specify the following `output.redis` options in the `auditbeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to false, the output is disabled.
The default value is `true`.

### `hosts`

The list of Redis servers to connect to. If load balancing is enabled, the events are distributed to the servers in the list. If one server becomes unreachable, the events are distributed to the reachable servers only. You can define each Redis server by specifying `HOST` or `HOST:PORT`. For example: `"192.15.3.2"` or `"test.redis.io:12345"`. If you don’t specify a port number, the value configured by `port` is used. Configure each Redis server with an `IP:PORT` pair or with a `URL`. For example: `redis://localhost:6379` or `rediss://localhost:6379`. URLs can include a server-specific password. For example: `redis://:password@localhost:6379`. The `redis` scheme will disable the `ssl` settings for the host, while `rediss` will enforce TLS.  If `rediss` is specified and no `ssl` settings are configured, the output uses the system certificate store.

### `index`

The index name added to the events metadata for use by Logstash. The default is "auditbeat".

### `key`

The name of the Redis list or channel the events are published to. If not configured, the value of the `index` setting is used.
You can set the key dynamically by using a format string to access any event field. For example, this configuration uses a custom field, `fields.list`, to set the Redis list key. If `fields.list` is missing, `fallback` is used:
```yaml
output.redis:
  hosts: ["localhost"]
  key: "%{[fields.list]:fallback}"
```

<tip>
  To learn how to add custom fields to events, see the [`fields`](/docs/reference/beats/auditbeat/configuration-general-options#libbeat-configuration-fields) option.
</tip>

See the [`keys`](#keys-option-redis) setting for other ways to set the key dynamically.

### `keys`

An array of key selector rules. Each rule specifies the `key` to use for events that match the rule. During publishing, Auditbeat uses the first matching rule in the array. Rules can contain conditionals, format string-based fields, and name mappings. If the `keys` setting is missing or no rule matches, the [`key`](#key-option-redis) setting is used.
Rule settings:
<definitions>
  <definition term="index">
    The key format string to use. If this string contains field references, such as `%{[fields.name]}`, the fields must exist, or the rule fails.
  </definition>
  <definition term="mappings">
    A dictionary that takes the value returned by `key` and maps it to a new name.
  </definition>
  <definition term="default">
    The default string value to use if `mappings` does not find a match.
  </definition>
  <definition term="when">
    A condition that must succeed in order to execute the current rule. All the [conditions](/docs/reference/beats/auditbeat/defining-processors#conditions) supported by processors are also supported here.
  </definition>
</definitions>

Example `keys` settings:
```yaml
output.redis:
  hosts: ["localhost"]
  key: "default_list"
  keys:
    - key: "info_list"  
      when.contains:
        message: "INFO"
    - key: "debug_list" 
      when.contains:
        message: "DEBUG"
    - key: "%{[fields.list]}"
      mappings:
        http: "frontend_list"
        nginx: "frontend_list"
        mysql: "backend_list"
```


### `password`

The password to authenticate with. The default is no authentication.

### `db`

The Redis database number where the events are published. The default is 0.

### `datatype`

The Redis data type to use for publishing events.If the data type is `list`, the Redis RPUSH command is used and all events are added to the list with the key defined under `key`. If the data type `channel` is used, the Redis `PUBLISH` command is used and means that all events are pushed to the pub/sub mechanism of Redis. The name of the channel is the one defined under `key`. The default value is `list`.

### `codec`

Output codec configuration. If the `codec` section is missing, events will be json encoded.
See [Change the output codec](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-output-codec) for more information.

### `worker` or `workers`

`worker` or `workers` specifies the number of connections created per host for publishing events.
Refer to the `loadblance` setting for details about how the load balancing works to distribute requests across the Elasticsearch cluster nodes.
The default value is `1`.

### `loadbalance`

When `loadbalance: true` is set, Auditbeat connects to all configured hosts and sends data through all connections in parallel. If a connection fails, data is sent to the remaining hosts until it can be reestablished. Data will still be sent as long as Auditbeat can connect to at least one of its configured hosts.
Use the `worker` or `workers` setting to specify the number of connections per host.
When `loadbalance: false` is set, Auditbeat sends data to a single host at a time. The target host is chosen at random from the list of configured hosts, and all data is sent to that target until the connection fails, when a new target is selected. Data will still be sent as long as Auditbeat can connect to at least one of its configured hosts.
The default value is `true`.

### `timeout`

The Redis connection timeout in seconds. The default is 5 seconds.

### `backoff.init`

The number of seconds to wait before trying to reconnect to Redis after a network error. After waiting `backoff.init` seconds, Auditbeat tries to reconnect. If the attempt fails, the backoff timer is increased exponentially up to `backoff.max`. After a successful connection, the backoff timer is reset. The default is 1s.

### `backoff.max`

The maximum number of seconds to wait before attempting to connect to Redis after a network error. The default is 60s.

### `max_retries`

The number of times to retry publishing an event after a publishing failure. After the specified number of retries, the events are typically dropped.
Set `max_retries` to a value less than 0 to retry until all events are published.
The default is 3.

### `bulk_max_size`

The maximum number of events to bulk in a single Redis request or pipeline. The default is 2048.
Events can be collected into batches. Auditbeat will split batches read from the queue which are larger than `bulk_max_size` into multiple batches.
Specifying a larger batch size can improve performance by lowering the overhead of sending events. However big batch sizes can also increase processing times, which might result in API errors, killed connections, timed-out publishing requests, and, ultimately, lower throughput.
Setting `bulk_max_size` to values less than or equal to 0 disables the splitting of batches. When splitting is disabled, the queue decides on the number of events to be contained in a batch.

### `ssl`

Configuration options for SSL parameters like the root CA for Redis connections guarded by SSL proxies (for example [stunnel](https://www.stunnel.org)). See [SSL](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-ssl) for more information.

### `proxy_url`

The URL of the SOCKS5 proxy to use when connecting to the Redis servers. The value must be a URL with a scheme of `socks5://`. You cannot use a web proxy because the protocol used to communicate with Redis is not based on HTTP.
If the SOCKS5 proxy server requires client authentication, you can embed a username and password in the URL.
When using a proxy, hostnames are resolved on the proxy server instead of on the client. You can change this behavior by setting the [`proxy_use_local_resolver`](#redis-proxy-use-local-resolver) option.

### `proxy_use_local_resolver`

This option determines whether Redis hostnames are resolved locally when using a proxy. The default value is false, which means that name resolution occurs on the proxy server.

### `queue`

Configuration options for internal queue.
See [Internal queue](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-internal-queue) for more information.
Note:`queue` options can be set under `auditbeat.yml` or the `output` section but not both.