﻿---
title: Load Kibana dashboards
description: Auditbeat comes packaged with example Kibana dashboards, visualizations, and searches for visualizing Auditbeat data in Kibana. Before you can use the...
url: https://www.elastic.co/docs/reference/beats/auditbeat/load-kibana-dashboards
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Load Kibana dashboards
Auditbeat comes packaged with example Kibana dashboards, visualizations, and searches for visualizing Auditbeat data in Kibana. Before you can use the dashboards, you need to create the index pattern, `auditbeat-*`, and load the dashboards into Kibana.
To do this, you can either run the `setup` command (as described here) or [configure dashboard loading](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-dashboards) in the `auditbeat.yml` config file. This requires a Kibana endpoint configuration. If you didn’t already configure a Kibana endpoint, see [Kibana endpoint](https://www.elastic.co/docs/reference/beats/auditbeat/setup-kibana-endpoint).

## Load dashboards

Make sure Kibana is running before you perform this step. If you are accessing a secured Kibana instance, make sure you’ve configured credentials as described in the [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration).
To load the recommended index template for writing to Elasticsearch and deploy the sample dashboards for visualizing the data in Kibana, use the command that works with your system.
<tab-set>
  <tab-item title="DEB">
    ```sh
    auditbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    auditbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./auditbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./auditbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="Docker">
    ```sh
    docker run --rm --net="host" docker.elastic.co/beats/auditbeat:9.3.0 setup --dashboards
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Auditbeat, and run:
    ```sh
    PS > .\auditbeat.exe setup --dashboards
    ```
  </tab-item>
</tab-set>

For more options, such as loading customized dashboards, see [Importing Existing Beat Dashboards](https://www.elastic.co/docs/extend/beats/import-dashboards).
If you’ve configured the Logstash output, see [Load dashboards for Logstash output](#load-dashboards-logstash).

## Load dashboards for Logstash output

During dashboard loading, Auditbeat connects to Elasticsearch to check version information. To load dashboards when the Logstash output is enabled, you need to temporarily disable the Logstash output and enable Elasticsearch. To connect to a secured Elasticsearch cluster, you also need to pass Elasticsearch credentials.
<tip>
  The example shows a hard-coded password, but you should store sensitive values in the [secrets keystore](https://www.elastic.co/docs/reference/beats/auditbeat/keystore).
</tip>

<tab-set>
  <tab-item title="DEB">
    ```sh
    auditbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=auditbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    auditbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=auditbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./auditbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=auditbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./auditbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=auditbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Docker">
    ```sh
    docker run --rm --net="host" docker.elastic.co/beats/auditbeat:9.3.0 setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=auditbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Auditbeat, and run:
    ```sh
    PS > .\auditbeat.exe setup -e `
      -E output.logstash.enabled=false `
      -E output.elasticsearch.hosts=['localhost:9200'] `
      -E output.elasticsearch.username=auditbeat_internal `
      -E output.elasticsearch.password=YOUR_PASSWORD `
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>
</tab-set>