﻿---
title: Configure the File output
description: The File output dumps the transactions into a file where each transaction is in a JSON format. Currently, this output is used for testing, but it can...
url: https://www.elastic.co/docs/reference/beats/auditbeat/file-output
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure the File output
The File output dumps the transactions into a file where each transaction is in a JSON format. Currently, this output is used for testing, but it can be used as input for Logstash.
To use this output, edit the Auditbeat configuration file to disable the Elasticsearch output by commenting it out, and enable the file output by adding `output.file`.
Example configuration:
```yaml
output.file:
  path: "/tmp/auditbeat"
  filename: auditbeat
  #rotate_every_kb: 10000
  #number_of_files: 7
  #permissions: 0600
  #rotate_on_startup: true
```


## Configuration options

You can specify the following `output.file` options in the `auditbeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to false, the output is disabled.
The default value is `true`.

### `path`

The path to the directory where the generated files will be saved. This option is mandatory.
The path may include the timestamp when the file output is initialized using the `+FORMAT` syntax where `FORMAT` is a valid [time format](https://github.com/elastic/beats/blob/main/libbeat/common/dtfmt/doc.go), and enclosed with expansion braces: `%{+FORMAT}`. For example:
```
path: 'fileoutput-%{+yyyy.MM.dd}'
```


### `filename`

The name of the generated files. The default is set to the Beat name. For example, the files generated by default for Auditbeat would be `"auditbeat-{{datetime}}.ndjson"`, `"auditbeat-{{datetime}}-1.ndjson"`, `"auditbeat-{{datetime}}-2.ndjson"`, and so on.

### `rotate_every_kb`

The maximum size in kilobytes of each file. When this size is reached, the files are rotated. The default value is 10240 KB.

### `number_of_files`

The maximum number of files to save under [`path`](#path). When this number of files is reached, the oldest file is deleted, and the rest of the files are shifted from last to first. The number of files must be between 2 and 1024. The default is 7.

### `permissions`

Permissions to use for file creation. The default is 0600.

### `rotate_on_startup`

If the output file already exists on startup, immediately rotate it and start writing to a new file instead of appending to the existing one. Defaults to true.

### `codec`

Output codec configuration. If the `codec` section is missing, events will be json encoded.
See [Change the output codec](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-output-codec) for more information.

### `queue`

Configuration options for internal queue.
See [Internal queue](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-internal-queue) for more information.
Note:`queue` options can be set under `auditbeat.yml` or the `output` section but not both.