﻿---
title: System fields
description: These are the fields generated by the system module. Hashes of the executable. The keys are algorithm names and the values are the hex encoded digest...
url: https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-system
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Beta
---

# System fields
These are the fields generated by the system module.
<definitions>
  <definition term="event.origin">
    Origin of the event. This can be a file path (e.g. `/var/log/log.1`), or the name of the system component that supplied the data (e.g. `netlink`).
    type: keyword
  </definition>
  <definition term="user.entity_id">
    ID uniquely identifying the user on a host. It is computed as a SHA-256 hash of the host ID, user ID, and user name.
    type: keyword
  </definition>
  <definition term="user.terminal">
    Terminal of the user.
    type: keyword
  </definition>
  <definition term="process.thread.capabilities.effective">
    This is the set of capabilities used by the kernel to perform permission checks for the thread.
    type: keyword
    example: ["CAP_BPF", "CAP_SYS_ADMIN"]
  </definition>
  <definition term="process.thread.capabilities.permitted">
    This is a limiting superset for the effective capabilities that the thread may assume.
    type: keyword
    example: ["CAP_BPF", "CAP_SYS_ADMIN"]
  </definition>
</definitions>


## hash

Hashes of the executable. The keys are algorithm names and the values are the hex encoded digest values.
<definitions>
  <definition term="process.hash.blake2b_256">
    BLAKE2b-256 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.blake2b_384">
    BLAKE2b-384 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.blake2b_512">
    BLAKE2b-512 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha224">
    SHA224 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha384">
    SHA384 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha3_224">
    SHA3_224 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha3_256">
    SHA3_256 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha3_384">
    SHA3_384 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha3_512">
    SHA3_512 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha512_224">
    SHA512/224 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.sha512_256">
    SHA512/256 hash of the executable.
    type: keyword
  </definition>
  <definition term="process.hash.xxh64">
    XX64 hash of the executable.
    type: keyword
  </definition>
</definitions>


## system.audit


## host

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`host` contains general host information.
<definitions>
  <definition term="system.audit.host.uptime">
    Uptime in nanoseconds.
    type: long
    format: duration
  </definition>
  <definition term="system.audit.host.boottime">
    Boot time.
    type: date
  </definition>
  <definition term="system.audit.host.containerized">
    Set if host is a container.
    type: boolean
  </definition>
  <definition term="system.audit.host.timezone.name">
    Name of the timezone of the host, e.g. BST.
    type: keyword
  </definition>
  <definition term="system.audit.host.timezone.offset.sec">
    Timezone offset in seconds.
    type: long
  </definition>
  <definition term="system.audit.host.hostname">
    Hostname.
    type: keyword
  </definition>
  <definition term="system.audit.host.id">
    Host ID.
    type: keyword
  </definition>
  <definition term="system.audit.host.architecture">
    Host architecture (e.g. x86_64).
    type: keyword
  </definition>
  <definition term="system.audit.host.mac">
    MAC addresses.
    type: keyword
  </definition>
  <definition term="system.audit.host.ip">
    IP addresses.
    type: ip
  </definition>
</definitions>


## os

`os` contains information about the operating system.
<definitions>
  <definition term="system.audit.host.os.codename">
    OS codename, if any (e.g. stretch).
    type: keyword
  </definition>
  <definition term="system.audit.host.os.platform">
    OS platform (e.g. centos, ubuntu, windows).
    type: keyword
  </definition>
  <definition term="system.audit.host.os.name">
    OS name (e.g. Mac OS X).
    type: keyword
  </definition>
  <definition term="system.audit.host.os.family">
    OS family (e.g. redhat, debian, freebsd, windows).
    type: keyword
  </definition>
  <definition term="system.audit.host.os.version">
    OS version.
    type: keyword
  </definition>
  <definition term="system.audit.host.os.kernel">
    The operating system's kernel version.
    type: keyword
  </definition>
  <definition term="system.audit.host.os.type">
    OS type (see ECS os.type).
    type: keyword
  </definition>
</definitions>


## package

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`package` contains information about an installed or removed package.
<definitions>
  <definition term="system.audit.package.entity_id">
    ID uniquely identifying the package. It is computed as a SHA-256 hash of the   host ID, package name, and package version.
    type: keyword
  </definition>
  <definition term="system.audit.package.name">
    Package name.
    type: keyword
  </definition>
  <definition term="system.audit.package.version">
    Package version.
    type: keyword
  </definition>
  <definition term="system.audit.package.release">
    Package release.
    type: keyword
  </definition>
  <definition term="system.audit.package.arch">
    Package architecture.
    type: keyword
  </definition>
  <definition term="system.audit.package.license">
    Package license.
    type: keyword
  </definition>
  <definition term="system.audit.package.installtime">
    Package install time.
    type: date
  </definition>
  <definition term="system.audit.package.size">
    Package size.
    type: long
  </definition>
  <definition term="system.audit.package.summary">
    Package summary.
  </definition>
  <definition term="system.audit.package.url">
    Package URL.
    type: keyword
  </definition>
</definitions>


## user

<applies-to>
  - Elastic Stack: Beta
</applies-to>

`user` contains information about the users on a system.
<definitions>
  <definition term="system.audit.user.name">
    User name.
    type: keyword
  </definition>
  <definition term="system.audit.user.uid">
    User ID.
    type: keyword
  </definition>
  <definition term="system.audit.user.gid">
    Group ID.
    type: keyword
  </definition>
  <definition term="system.audit.user.dir">
    User's home directory.
    type: keyword
  </definition>
  <definition term="system.audit.user.shell">
    Program to run at login.
    type: keyword
  </definition>
  <definition term="system.audit.user.user_information">
    General user information. On Linux, this is the gecos field.
    type: keyword
  </definition>
  <definition term="system.audit.user.group">
    `group` contains information about any groups the user is part of (beyond the user's primary group).
    type: object
  </definition>
</definitions>


## password

`password` contains information about a user's password (not the password itself).
<definitions>
  <definition term="system.audit.user.password.type">
    A user's password type. Possible values are `shadow_password` (the password hash is in the shadow file), `password_disabled`, `no_password` (this is dangerous as anyone can log in), and `crypt_password` (when the password field in /etc/passwd seems to contain an encrypted password).
    type: keyword
  </definition>
  <definition term="system.audit.user.password.last_changed">
    The day the user's password was last changed.
    type: date
  </definition>
</definitions>