﻿---
title: File Integrity fields
description: These are the fields generated by the file_integrity module. File attributes. These fields contain Linux Executable Linkable Format (ELF) metadata. These...
url: https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-file_integrity
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# File Integrity fields
These are the fields generated by the file_integrity module.

## file

File attributes.

## elf

These fields contain Linux Executable Linkable Format (ELF) metadata.
<definitions>
  <definition term="file.elf.go_imports">
    List of imported Go language element names and types.
    type: flattened
  </definition>
  <definition term="file.elf.go_imports_names_entropy">
    Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.elf.go_imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.elf.go_import_hash">
    A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. The algorithm used to calculate the Go symbol hash and a reference implementation are available [here](https://github.com/elastic/toutoumomoma).
    type: keyword
    example: 10bddcb4cee42080f76c88d9ff964491
  </definition>
  <definition term="file.elf.go_stripped">
    Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.
    type: boolean
  </definition>
  <definition term="file.elf.imports_names_entropy">
    Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.elf.imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.elf.import_hash">
    A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. This is an ELF implementation of the Windows PE imphash.
    type: keyword
    example: d41d8cd98f00b204e9800998ecf8427e
  </definition>
  <definition term="file.elf.sections.var_entropy">
    Variance for Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
</definitions>


## macho

These fields contain Mach object file Format (Mach-O) metadata.
<definitions>
  <definition term="file.macho.go_imports">
    List of imported Go language element names and types.
    type: flattened
  </definition>
  <definition term="file.macho.go_imports_names_entropy">
    Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.macho.go_imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.macho.go_import_hash">
    A hash of the Go language imports in a Mach-O file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. The algorithm used to calculate the Go symbol hash and a reference implementation are available [here](https://github.com/elastic/toutoumomoma).
    type: keyword
    example: 10bddcb4cee42080f76c88d9ff964491
  </definition>
  <definition term="file.macho.go_stripped">
    Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.
    type: boolean
  </definition>
  <definition term="file.macho.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="file.macho.imports_names_entropy">
    Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.macho.imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.macho.import_hash">
    A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. This is a synonym for symhash.
    type: keyword
    example: d3ccf195b62a9279c3c19af1080497ec
  </definition>
  <definition term="file.macho.sections">
    An array containing an object for each section of the Mach-O file. The keys that should be present in these objects are defined by sub-fields underneath `macho.sections.*`.
    type: nested
  </definition>
  <definition term="file.macho.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="file.macho.sections.var_entropy">
    Variance for Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="file.macho.sections.name">
    Mach-O Section List name.
    type: keyword
  </definition>
  <definition term="file.macho.sections.physical_size">
    Mach-O Section List physical size.
    type: long
    format: string
  </definition>
  <definition term="file.macho.sections.virtual_size">
    Mach-O Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="file.macho.symhash">
    A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.
    type: keyword
    example: d3ccf195b62a9279c3c19af1080497ec
  </definition>
</definitions>


## pe

These fields contain Windows Portable Executable (PE) metadata.
<definitions>
  <definition term="file.pe.go_imports">
    List of imported Go language element names and types.
    type: flattened
  </definition>
  <definition term="file.pe.go_imports_names_entropy">
    Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.pe.go_imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of Go imports.
    type: long
    format: number
  </definition>
  <definition term="file.pe.go_import_hash">
    A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. The algorithm used to calculate the Go symbol hash and a reference implementation are available [here](https://github.com/elastic/toutoumomoma).
    type: keyword
    example: 10bddcb4cee42080f76c88d9ff964491
  </definition>
  <definition term="file.pe.go_stripped">
    Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.
    type: boolean
  </definition>
  <definition term="file.pe.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="file.pe.imports_names_entropy">
    Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.pe.imports_names_var_entropy">
    Variance for Shannon entropy calculation from the list of imported element names and types.
    type: long
    format: number
  </definition>
  <definition term="file.pe.import_hash">
    A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. This is a synonym for imphash.
    type: keyword
  </definition>
  <definition term="file.pe.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.
    type: nested
  </definition>
  <definition term="file.pe.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="file.pe.sections.var_entropy">
    Variance for Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="file.pe.sections.name">
    PE Section List name.
    type: keyword
  </definition>
  <definition term="file.pe.sections.physical_size">
    PE Section List physical size.
    type: long
    format: string
  </definition>
  <definition term="file.pe.sections.virtual_size">
    PE Section List virtual size.
    type: long
    format: string
  </definition>
</definitions>


## hash

Hashes of the file. The keys are algorithm names and the values are the hex encoded digest values.
<definitions>
  <definition term="hash.blake2b_256">
    BLAKE2b-256 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.blake2b_384">
    BLAKE2b-384 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.blake2b_512">
    BLAKE2b-512 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.md5">
    MD5 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha1">
    SHA1 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha224">
    SHA224 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha256">
    SHA256 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha384">
    SHA384 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha3_224">
    SHA3_224 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha3_256">
    SHA3_256 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha3_384">
    SHA3_384 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha3_512">
    SHA3_512 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha512">
    SHA512 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha512_224">
    SHA512/224 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.sha512_256">
    SHA512/256 hash of the file.
    type: keyword
  </definition>
  <definition term="hash.xxh64">
    XX64 hash of the file.
    type: keyword
  </definition>
</definitions>