﻿---
title: Common fields
description: Contains common fields available in all event types. File attributes. The SELinux identity of the file. User information. Audit user information. Filesystem...
url: https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-common
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Common fields
Contains common fields available in all event types.

## file

File attributes.
<definitions>
  <definition term="file.setuid">
    Set if the file has the `setuid` bit set. Omitted otherwise.
    type: boolean
    example: True
  </definition>
  <definition term="file.setgid">
    Set if the file has the `setgid` bit set. Omitted otherwise.
    type: boolean
    example: True
  </definition>
  <definition term="file.origin">
    An array of strings describing a possible external origin for this file. For example, the URL it was downloaded from. Only supported in macOS, via the kMDItemWhereFroms attribute. Omitted if origin information is not available.
    type: keyword
  </definition>
  <definition term="file.origin.text">
    This is an analyzed field that is useful for full text search on the origin data.
    type: text
  </definition>
</definitions>


## selinux

The SELinux identity of the file.
<definitions>
  <definition term="file.selinux.user">
    The owner of the object.
    type: keyword
  </definition>
  <definition term="file.selinux.role">
    The object's SELinux role.
    type: keyword
  </definition>
  <definition term="file.selinux.domain">
    The object's SELinux domain or type.
    type: keyword
  </definition>
  <definition term="file.selinux.level">
    The object's SELinux level.
    type: keyword
    example: s0
  </definition>
  <definition term="file.extended_attributes Elastic Stack: Preview since 9.2">
    Extended file attributes. Contains NTFS Extended Attributes (EAs) on Windows systems. Extended Attributes are name-value pairs that can be attached to files and directories to store additional metadata beyond standard file attributes. The object contains key-value pairs where keys are EA names and values are their corresponding values. This field is only populated on Windows and only when the file has extended attributes.
    type: flattened
  </definition>
</definitions>


## user

User information.

## audit

Audit user information.
<definitions>
  <definition term="user.audit.id">
    Audit user ID.
    type: keyword
  </definition>
  <definition term="user.audit.name">
    Audit user name.
    type: keyword
  </definition>
</definitions>


## filesystem

Filesystem user information.
<definitions>
  <definition term="user.filesystem.id">
    Filesystem user ID.
    type: keyword
  </definition>
  <definition term="user.filesystem.name">
    Filesystem user name.
    type: keyword
  </definition>
</definitions>


## group

Filesystem group information.
<definitions>
  <definition term="user.filesystem.group.id">
    Filesystem group ID.
    type: keyword
  </definition>
  <definition term="user.filesystem.group.name">
    Filesystem group name.
    type: keyword
  </definition>
</definitions>


## saved

Saved user information.
<definitions>
  <definition term="user.saved.id">
    Saved user ID.
    type: keyword
  </definition>
  <definition term="user.saved.name">
    Saved user name.
    type: keyword
  </definition>
</definitions>


## group

Saved group information.
<definitions>
  <definition term="user.saved.group.id">
    Saved group ID.
    type: keyword
  </definition>
  <definition term="user.saved.group.name">
    Saved group name.
    type: keyword
  </definition>
</definitions>