﻿---
title: Auditd fields
description: These are the fields generated by the auditd module. If resolve_ids is set to true in the configuration then name_map will contain a mapping of uid field...
url: https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-auditd
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Auditd fields
These are the fields generated by the auditd module.
<definitions>
  <definition term="user.auid">
    type: alias
    alias to: user.audit.id
  </definition>
  <definition term="user.uid">
    type: alias
    alias to: user.id
  </definition>
  <definition term="user.fsuid">
    type: alias
    alias to: user.filesystem.id
  </definition>
  <definition term="user.suid">
    type: alias
    alias to: user.saved.id
  </definition>
  <definition term="user.gid">
    type: alias
    alias to: user.group.id
  </definition>
  <definition term="user.sgid">
    type: alias
    alias to: user.saved.group.id
  </definition>
  <definition term="user.fsgid">
    type: alias
    alias to: user.filesystem.group.id
  </definition>
</definitions>


## name_map

If `resolve_ids` is set to true in the configuration then `name_map` will contain a mapping of uid field names to the resolved name (e.g. auid -> root).
<definitions>
  <definition term="user.name_map.auid">
    type: alias
    alias to: user.audit.name
  </definition>
  <definition term="user.name_map.uid">
    type: alias
    alias to: user.name
  </definition>
  <definition term="user.name_map.fsuid">
    type: alias
    alias to: user.filesystem.name
  </definition>
  <definition term="user.name_map.suid">
    type: alias
    alias to: user.saved.name
  </definition>
  <definition term="user.name_map.gid">
    type: alias
    alias to: user.group.name
  </definition>
  <definition term="user.name_map.sgid">
    type: alias
    alias to: user.saved.group.name
  </definition>
  <definition term="user.name_map.fsgid">
    type: alias
    alias to: user.filesystem.group.name
  </definition>
</definitions>


## selinux

The SELinux identity of the actor.
<definitions>
  <definition term="user.selinux.user">
    account submitted for authentication
    type: keyword
  </definition>
  <definition term="user.selinux.role">
    user's SELinux role
    type: keyword
  </definition>
  <definition term="user.selinux.domain">
    The actor's SELinux domain or type.
    type: keyword
  </definition>
  <definition term="user.selinux.level">
    The actor's SELinux level.
    type: keyword
    example: s0
  </definition>
  <definition term="user.selinux.category">
    The actor's SELinux category or compartments.
    type: keyword
  </definition>
</definitions>


## process

Process attributes.
<definitions>
  <definition term="process.cwd">
    The current working directory.
    type: alias
    alias to: process.working_directory
  </definition>
</definitions>


## source

Source that triggered the event.
<definitions>
  <definition term="source.path">
    This is the path associated with a unix socket.
    type: keyword
  </definition>
</definitions>


## destination

Destination address that triggered the event.
<definitions>
  <definition term="destination.path">
    This is the path associated with a unix socket.
    type: keyword
  </definition>
  <definition term="auditd.message_type">
    The audit message type (e.g. syscall or apparmor_denied).
    type: keyword
    example: syscall
  </definition>
  <definition term="auditd.sequence">
    The sequence number of the event as assigned by the kernel. Sequence numbers are stored as a uint32 in the kernel and can rollover.
    type: long
  </definition>
  <definition term="auditd.session">
    The session ID assigned to a login. All events related to a login session will have the same value.
    type: keyword
  </definition>
  <definition term="auditd.result">
    The result of the audited operation (success/fail).
    type: keyword
    example: success or fail
  </definition>
</definitions>


## actor

The actor is the user that triggered the audit event.
<definitions>
  <definition term="auditd.summary.actor.primary">
    The primary identity of the actor. This is the actor's original login ID. It will not change even if the user changes to another account.
    type: keyword
  </definition>
  <definition term="auditd.summary.actor.secondary">
    The secondary identity of the actor. This is typically the same as the primary, except for when the user has used `su`.
    type: keyword
  </definition>
</definitions>


## object

This is the thing or object being acted upon in the event.
<definitions>
  <definition term="auditd.summary.object.type">
    A description of the what the "thing" is (e.g. file, socket, user-session).
    type: keyword
  </definition>
  <definition term="auditd.summary.object.primary">
    type: keyword
  </definition>
  <definition term="auditd.summary.object.secondary">
    type: keyword
  </definition>
  <definition term="auditd.summary.how">
    This describes how the action was performed. Usually this is the exe or command that was being executed that triggered the event.
    type: keyword
  </definition>
</definitions>


## paths

List of paths associated with the event.
<definitions>
  <definition term="auditd.paths.inode">
    inode number
    type: keyword
  </definition>
  <definition term="auditd.paths.dev">
    device name as found in /dev
    type: keyword
  </definition>
  <definition term="auditd.paths.obj_user">
    type: keyword
  </definition>
  <definition term="auditd.paths.obj_role">
    type: keyword
  </definition>
  <definition term="auditd.paths.obj_domain">
    type: keyword
  </definition>
  <definition term="auditd.paths.obj_level">
    type: keyword
  </definition>
  <definition term="auditd.paths.objtype">
    type: keyword
  </definition>
  <definition term="auditd.paths.ouid">
    file owner user ID
    type: keyword
  </definition>
  <definition term="auditd.paths.rdev">
    the device identifier (special files only)
    type: keyword
  </definition>
  <definition term="auditd.paths.nametype">
    kind of file operation being referenced
    type: keyword
  </definition>
  <definition term="auditd.paths.ogid">
    file owner group ID
    type: keyword
  </definition>
  <definition term="auditd.paths.item">
    which item is being recorded
    type: keyword
  </definition>
  <definition term="auditd.paths.mode">
    mode flags on a file
    type: keyword
  </definition>
  <definition term="auditd.paths.name">
    file name in avcs
    type: keyword
  </definition>
</definitions>


## data

The data from the audit messages.
<definitions>
  <definition term="auditd.data.action">
    netfilter packet disposition
    type: keyword
  </definition>
  <definition term="auditd.data.minor">
    device minor number
    type: keyword
  </definition>
  <definition term="auditd.data.acct">
    a user's account name
    type: keyword
  </definition>
  <definition term="auditd.data.addr">
    the remote address that the user is connecting from
    type: keyword
  </definition>
  <definition term="auditd.data.cipher">
    name of crypto cipher selected
    type: keyword
  </definition>
  <definition term="auditd.data.id">
    during account changes
    type: keyword
  </definition>
  <definition term="auditd.data.entries">
    number of entries in the netfilter table
    type: keyword
  </definition>
  <definition term="auditd.data.kind">
    server or client in crypto operation
    type: keyword
  </definition>
  <definition term="auditd.data.ksize">
    key size for crypto operation
    type: keyword
  </definition>
  <definition term="auditd.data.spid">
    sent process ID
    type: keyword
  </definition>
  <definition term="auditd.data.arch">
    the elf architecture flags
    type: keyword
  </definition>
  <definition term="auditd.data.argc">
    the number of arguments to an execve syscall
    type: keyword
  </definition>
  <definition term="auditd.data.major">
    device major number
    type: keyword
  </definition>
  <definition term="auditd.data.unit">
    systemd unit
    type: keyword
  </definition>
  <definition term="auditd.data.table">
    netfilter table name
    type: keyword
  </definition>
  <definition term="auditd.data.terminal">
    terminal name the user is running programs on
    type: keyword
  </definition>
  <definition term="auditd.data.grantors">
    pam modules approving the action
    type: keyword
  </definition>
  <definition term="auditd.data.direction">
    direction of crypto operation
    type: keyword
  </definition>
  <definition term="auditd.data.op">
    the operation being performed that is audited
    type: keyword
  </definition>
  <definition term="auditd.data.tty">
    tty udevice the user is running programs on
    type: keyword
  </definition>
  <definition term="auditd.data.syscall">
    syscall number in effect when the event occurred
    type: keyword
  </definition>
  <definition term="auditd.data.data">
    TTY text
    type: keyword
  </definition>
  <definition term="auditd.data.family">
    netfilter protocol
    type: keyword
  </definition>
  <definition term="auditd.data.mac">
    crypto MAC algorithm selected
    type: keyword
  </definition>
  <definition term="auditd.data.pfs">
    perfect forward secrecy method
    type: keyword
  </definition>
  <definition term="auditd.data.items">
    the number of path records in the event
    type: keyword
  </definition>
  <definition term="auditd.data.a0">
    type: keyword
  </definition>
  <definition term="auditd.data.a1">
    type: keyword
  </definition>
  <definition term="auditd.data.a2">
    type: keyword
  </definition>
  <definition term="auditd.data.a3">
    type: keyword
  </definition>
  <definition term="auditd.data.hostname">
    the hostname that the user is connecting from
    type: keyword
  </definition>
  <definition term="auditd.data.lport">
    local network port
    type: keyword
  </definition>
  <definition term="auditd.data.rport">
    remote port number
    type: keyword
  </definition>
  <definition term="auditd.data.exit">
    syscall exit code
    type: keyword
  </definition>
  <definition term="auditd.data.fp">
    crypto key finger print
    type: keyword
  </definition>
  <definition term="auditd.data.laddr">
    local network address
    type: keyword
  </definition>
  <definition term="auditd.data.sport">
    local port number
    type: keyword
  </definition>
  <definition term="auditd.data.capability">
    posix capabilities
    type: keyword
  </definition>
  <definition term="auditd.data.nargs">
    the number of arguments to a socket call
    type: keyword
  </definition>
  <definition term="auditd.data.new-enabled">
    new TTY audit enabled setting
    type: keyword
  </definition>
  <definition term="auditd.data.audit_backlog_limit">
    audit system's backlog queue size
    type: keyword
  </definition>
  <definition term="auditd.data.dir">
    directory name
    type: keyword
  </definition>
  <definition term="auditd.data.cap_pe">
    process effective capability map
    type: keyword
  </definition>
  <definition term="auditd.data.model">
    security model being used for virt
    type: keyword
  </definition>
  <definition term="auditd.data.new_pp">
    new process permitted capability map
    type: keyword
  </definition>
  <definition term="auditd.data.old-enabled">
    present TTY audit enabled setting
    type: keyword
  </definition>
  <definition term="auditd.data.oauid">
    object's login user ID
    type: keyword
  </definition>
  <definition term="auditd.data.old">
    old value
    type: keyword
  </definition>
  <definition term="auditd.data.banners">
    banners used on printed page
    type: keyword
  </definition>
  <definition term="auditd.data.feature">
    kernel feature being changed
    type: keyword
  </definition>
  <definition term="auditd.data.vm-ctx">
    the vm's context string
    type: keyword
  </definition>
  <definition term="auditd.data.opid">
    object's process ID
    type: keyword
  </definition>
  <definition term="auditd.data.seperms">
    SELinux permissions being used
    type: keyword
  </definition>
  <definition term="auditd.data.seresult">
    SELinux AVC decision granted/denied
    type: keyword
  </definition>
  <definition term="auditd.data.new-rng">
    device name of rng being added from a vm
    type: keyword
  </definition>
  <definition term="auditd.data.old-net">
    present MAC address assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.sigev_signo">
    signal number
    type: keyword
  </definition>
  <definition term="auditd.data.ino">
    inode number
    type: keyword
  </definition>
  <definition term="auditd.data.old_enforcing">
    old MAC enforcement status
    type: keyword
  </definition>
  <definition term="auditd.data.old-vcpu">
    present number of CPU cores
    type: keyword
  </definition>
  <definition term="auditd.data.range">
    user's SE Linux range
    type: keyword
  </definition>
  <definition term="auditd.data.res">
    result of the audited operation(success/fail)
    type: keyword
  </definition>
  <definition term="auditd.data.added">
    number of new files detected
    type: keyword
  </definition>
  <definition term="auditd.data.fam">
    socket address family
    type: keyword
  </definition>
  <definition term="auditd.data.nlnk-pid">
    pid of netlink packet sender
    type: keyword
  </definition>
  <definition term="auditd.data.subj">
    lspp subject's context string
    type: keyword
  </definition>
  <definition term="auditd.data.a[0-3]">
    the arguments to a syscall
    type: keyword
  </definition>
  <definition term="auditd.data.cgroup">
    path to cgroup in sysfs
    type: keyword
  </definition>
  <definition term="auditd.data.kernel">
    kernel's version number
    type: keyword
  </definition>
  <definition term="auditd.data.ocomm">
    object's command line name
    type: keyword
  </definition>
  <definition term="auditd.data.new-net">
    MAC address being assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.permissive">
    SELinux is in permissive mode
    type: keyword
  </definition>
  <definition term="auditd.data.class">
    resource class assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.compat">
    is_compat_task result
    type: keyword
  </definition>
  <definition term="auditd.data.fi">
    file assigned inherited capability map
    type: keyword
  </definition>
  <definition term="auditd.data.changed">
    number of changed files
    type: keyword
  </definition>
  <definition term="auditd.data.msg">
    the payload of the audit record
    type: keyword
  </definition>
  <definition term="auditd.data.dport">
    remote port number
    type: keyword
  </definition>
  <definition term="auditd.data.new-seuser">
    new SELinux user
    type: keyword
  </definition>
  <definition term="auditd.data.invalid_context">
    SELinux context
    type: keyword
  </definition>
  <definition term="auditd.data.dmac">
    remote MAC address
    type: keyword
  </definition>
  <definition term="auditd.data.ipx-net">
    IPX network number
    type: keyword
  </definition>
  <definition term="auditd.data.iuid">
    ipc object's user ID
    type: keyword
  </definition>
  <definition term="auditd.data.macproto">
    ethernet packet type ID field
    type: keyword
  </definition>
  <definition term="auditd.data.obj">
    lspp object context string
    type: keyword
  </definition>
  <definition term="auditd.data.ipid">
    IP datagram fragment identifier
    type: keyword
  </definition>
  <definition term="auditd.data.new-fs">
    file system being added to vm
    type: keyword
  </definition>
  <definition term="auditd.data.vm-pid">
    vm's process ID
    type: keyword
  </definition>
  <definition term="auditd.data.cap_pi">
    process inherited capability map
    type: keyword
  </definition>
  <definition term="auditd.data.old-auid">
    previous auid value
    type: keyword
  </definition>
  <definition term="auditd.data.oses">
    object's session ID
    type: keyword
  </definition>
  <definition term="auditd.data.fd">
    file descriptor number
    type: keyword
  </definition>
  <definition term="auditd.data.igid">
    ipc object's group ID
    type: keyword
  </definition>
  <definition term="auditd.data.new-disk">
    disk being added to vm
    type: keyword
  </definition>
  <definition term="auditd.data.parent">
    the inode number of the parent file
    type: keyword
  </definition>
  <definition term="auditd.data.len">
    length
    type: keyword
  </definition>
  <definition term="auditd.data.oflag">
    open syscall flags
    type: keyword
  </definition>
  <definition term="auditd.data.uuid">
    a UUID
    type: keyword
  </definition>
  <definition term="auditd.data.code">
    seccomp action code
    type: keyword
  </definition>
  <definition term="auditd.data.nlnk-grp">
    netlink group number
    type: keyword
  </definition>
  <definition term="auditd.data.cap_fp">
    file permitted capability map
    type: keyword
  </definition>
  <definition term="auditd.data.new-mem">
    new amount of memory in KB
    type: keyword
  </definition>
  <definition term="auditd.data.seperm">
    SELinux permission being decided on
    type: keyword
  </definition>
  <definition term="auditd.data.enforcing">
    new MAC enforcement status
    type: keyword
  </definition>
  <definition term="auditd.data.new-chardev">
    new character device being assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.old-rng">
    device name of rng being removed from a vm
    type: keyword
  </definition>
  <definition term="auditd.data.outif">
    out interface number
    type: keyword
  </definition>
  <definition term="auditd.data.cmd">
    command being executed
    type: keyword
  </definition>
  <definition term="auditd.data.hook">
    netfilter hook that packet came from
    type: keyword
  </definition>
  <definition term="auditd.data.new-level">
    new run level
    type: keyword
  </definition>
  <definition term="auditd.data.sauid">
    sent login user ID
    type: keyword
  </definition>
  <definition term="auditd.data.sig">
    signal number
    type: keyword
  </definition>
  <definition term="auditd.data.audit_backlog_wait_time">
    audit system's backlog wait time
    type: keyword
  </definition>
  <definition term="auditd.data.printer">
    printer name
    type: keyword
  </definition>
  <definition term="auditd.data.old-mem">
    present amount of memory in KB
    type: keyword
  </definition>
  <definition term="auditd.data.perm">
    the file permission being used
    type: keyword
  </definition>
  <definition term="auditd.data.old_pi">
    old process inherited capability map
    type: keyword
  </definition>
  <definition term="auditd.data.state">
    audit daemon configuration resulting state
    type: keyword
  </definition>
  <definition term="auditd.data.format">
    audit log's format
    type: keyword
  </definition>
  <definition term="auditd.data.new_gid">
    new group ID being assigned
    type: keyword
  </definition>
  <definition term="auditd.data.tcontext">
    the target's or object's context string
    type: keyword
  </definition>
  <definition term="auditd.data.maj">
    device major number
    type: keyword
  </definition>
  <definition term="auditd.data.watch">
    file name in a watch record
    type: keyword
  </definition>
  <definition term="auditd.data.device">
    device name
    type: keyword
  </definition>
  <definition term="auditd.data.grp">
    group name
    type: keyword
  </definition>
  <definition term="auditd.data.bool">
    name of SELinux boolean
    type: keyword
  </definition>
  <definition term="auditd.data.icmp_type">
    type of icmp message
    type: keyword
  </definition>
  <definition term="auditd.data.new_lock">
    new value of feature lock
    type: keyword
  </definition>
  <definition term="auditd.data.old_prom">
    network promiscuity flag
    type: keyword
  </definition>
  <definition term="auditd.data.acl">
    access mode of resource assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.ip">
    network address of a printer
    type: keyword
  </definition>
  <definition term="auditd.data.new_pi">
    new process inherited capability map
    type: keyword
  </definition>
  <definition term="auditd.data.default-context">
    default MAC context
    type: keyword
  </definition>
  <definition term="auditd.data.inode_gid">
    group ID of the inode's owner
    type: keyword
  </definition>
  <definition term="auditd.data.new-log_passwd">
    new value for TTY password logging
    type: keyword
  </definition>
  <definition term="auditd.data.new_pe">
    new process effective capability map
    type: keyword
  </definition>
  <definition term="auditd.data.selected-context">
    new MAC context assigned to session
    type: keyword
  </definition>
  <definition term="auditd.data.cap_fver">
    file system capabilities version number
    type: keyword
  </definition>
  <definition term="auditd.data.file">
    file name
    type: keyword
  </definition>
  <definition term="auditd.data.net">
    network MAC address
    type: keyword
  </definition>
  <definition term="auditd.data.virt">
    kind of virtualization being referenced
    type: keyword
  </definition>
  <definition term="auditd.data.cap_pp">
    process permitted capability map
    type: keyword
  </definition>
  <definition term="auditd.data.old-range">
    present SELinux range
    type: keyword
  </definition>
  <definition term="auditd.data.resrc">
    resource being assigned
    type: keyword
  </definition>
  <definition term="auditd.data.new-range">
    new SELinux range
    type: keyword
  </definition>
  <definition term="auditd.data.obj_gid">
    group ID of object
    type: keyword
  </definition>
  <definition term="auditd.data.proto">
    network protocol
    type: keyword
  </definition>
  <definition term="auditd.data.old-disk">
    disk being removed from vm
    type: keyword
  </definition>
  <definition term="auditd.data.audit_failure">
    audit system's failure mode
    type: keyword
  </definition>
  <definition term="auditd.data.inif">
    in interface number
    type: keyword
  </definition>
  <definition term="auditd.data.vm">
    virtual machine name
    type: keyword
  </definition>
  <definition term="auditd.data.flags">
    mmap syscall flags
    type: keyword
  </definition>
  <definition term="auditd.data.nlnk-fam">
    netlink protocol number
    type: keyword
  </definition>
  <definition term="auditd.data.old-fs">
    file system being removed from vm
    type: keyword
  </definition>
  <definition term="auditd.data.old-ses">
    previous ses value
    type: keyword
  </definition>
  <definition term="auditd.data.seqno">
    sequence number
    type: keyword
  </definition>
  <definition term="auditd.data.fver">
    file system capabilities version number
    type: keyword
  </definition>
  <definition term="auditd.data.qbytes">
    ipc objects quantity of bytes
    type: keyword
  </definition>
  <definition term="auditd.data.seuser">
    user's SE Linux user acct
    type: keyword
  </definition>
  <definition term="auditd.data.cap_fe">
    file assigned effective capability map
    type: keyword
  </definition>
  <definition term="auditd.data.new-vcpu">
    new number of CPU cores
    type: keyword
  </definition>
  <definition term="auditd.data.old-level">
    old run level
    type: keyword
  </definition>
  <definition term="auditd.data.old_pp">
    old process permitted capability map
    type: keyword
  </definition>
  <definition term="auditd.data.daddr">
    remote IP address
    type: keyword
  </definition>
  <definition term="auditd.data.old-role">
    present SELinux role
    type: keyword
  </definition>
  <definition term="auditd.data.ioctlcmd">
    The request argument to the ioctl syscall
    type: keyword
  </definition>
  <definition term="auditd.data.smac">
    local MAC address
    type: keyword
  </definition>
  <definition term="auditd.data.apparmor">
    apparmor event information
    type: keyword
  </definition>
  <definition term="auditd.data.fe">
    file assigned effective capability map
    type: keyword
  </definition>
  <definition term="auditd.data.perm_mask">
    file permission mask that triggered a watch event
    type: keyword
  </definition>
  <definition term="auditd.data.ses">
    login session ID
    type: keyword
  </definition>
  <definition term="auditd.data.cap_fi">
    file inherited capability map
    type: keyword
  </definition>
  <definition term="auditd.data.obj_uid">
    user ID of object
    type: keyword
  </definition>
  <definition term="auditd.data.reason">
    text string denoting a reason for the action
    type: keyword
  </definition>
  <definition term="auditd.data.list">
    the audit system's filter list number
    type: keyword
  </definition>
  <definition term="auditd.data.old_lock">
    present value of feature lock
    type: keyword
  </definition>
  <definition term="auditd.data.bus">
    name of subsystem bus a vm resource belongs to
    type: keyword
  </definition>
  <definition term="auditd.data.old_pe">
    old process effective capability map
    type: keyword
  </definition>
  <definition term="auditd.data.new-role">
    new SELinux role
    type: keyword
  </definition>
  <definition term="auditd.data.prom">
    network promiscuity flag
    type: keyword
  </definition>
  <definition term="auditd.data.uri">
    URI pointing to a printer
    type: keyword
  </definition>
  <definition term="auditd.data.audit_enabled">
    audit systems's enable/disable status
    type: keyword
  </definition>
  <definition term="auditd.data.old-log_passwd">
    present value for TTY password logging
    type: keyword
  </definition>
  <definition term="auditd.data.old-seuser">
    present SELinux user
    type: keyword
  </definition>
  <definition term="auditd.data.per">
    linux personality
    type: keyword
  </definition>
  <definition term="auditd.data.scontext">
    the subject's context string
    type: keyword
  </definition>
  <definition term="auditd.data.tclass">
    target's object classification
    type: keyword
  </definition>
  <definition term="auditd.data.ver">
    audit daemon's version number
    type: keyword
  </definition>
  <definition term="auditd.data.new">
    value being set in feature
    type: keyword
  </definition>
  <definition term="auditd.data.val">
    generic value associated with the operation
    type: keyword
  </definition>
  <definition term="auditd.data.img-ctx">
    the vm's disk image context string
    type: keyword
  </definition>
  <definition term="auditd.data.old-chardev">
    present character device assigned to vm
    type: keyword
  </definition>
  <definition term="auditd.data.old_val">
    current value of SELinux boolean
    type: keyword
  </definition>
  <definition term="auditd.data.success">
    whether the syscall was successful or not
    type: keyword
  </definition>
  <definition term="auditd.data.inode_uid">
    user ID of the inode's owner
    type: keyword
  </definition>
  <definition term="auditd.data.removed">
    number of deleted files
    type: keyword
  </definition>
  <definition term="auditd.data.socket.port">
    The port number.
    type: keyword
  </definition>
  <definition term="auditd.data.socket.saddr">
    The raw socket address structure.
    type: keyword
  </definition>
  <definition term="auditd.data.socket.addr">
    The remote address.
    type: keyword
  </definition>
  <definition term="auditd.data.socket.family">
    The socket family (unix, ipv4, ipv6, netlink).
    type: keyword
    example: unix
  </definition>
  <definition term="auditd.data.socket.path">
    This is the path associated with a unix socket.
    type: keyword
  </definition>
  <definition term="auditd.messages">
    An ordered list of the raw messages received from the kernel that were used to construct this document. This field is present if an error occurred processing the data or if `include_raw_message` is set in the config.
    type: alias
    alias to: event.original
  </definition>
  <definition term="auditd.warnings">
    The warnings generated by the Beat during the construction of the event. These are disabled by default and are used for development and debug purposes only.
    type: alias
    alias to: error.message
  </definition>
</definitions>


## geoip

The geoip fields are defined as a convenience in case you decide to enrich the data using a geoip filter in Logstash or an Elasticsearch geoip ingest processor.
<definitions>
  <definition term="geoip.continent_name">
    The name of the continent.
    type: keyword
  </definition>
  <definition term="geoip.city_name">
    The name of the city.
    type: keyword
  </definition>
  <definition term="geoip.region_name">
    The name of the region.
    type: keyword
  </definition>
  <definition term="geoip.country_iso_code">
    Country ISO code.
    type: keyword
  </definition>
  <definition term="geoip.location">
    The longitude and latitude.
    type: geo_point
  </definition>
</definitions>