﻿---
title: Directory layout
description: The directory layout of an installation is as follows: You can change these settings by using CLI flags or setting path options in the configuration file...
url: https://www.elastic.co/docs/reference/beats/auditbeat/directory-layout
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Directory layout
The directory layout of an installation is as follows:
<tip>
  Archive installation has a different layout. See [zip, tar.gz, or tgz](#directory-layout-archive).
</tip>


| Type   | Description                                     | Default Location   | Config Option |
|--------|-------------------------------------------------|--------------------|---------------|
| home   | Home of the Auditbeat installation.             |                    | `path.home`   |
| bin    | The location for the binary files.              | `{path.home}/bin`  |               |
| config | The location for configuration files.           | `{path.home}`      | `path.config` |
| data   | The location for persistent data files.         | `{path.home}/data` | `path.data`   |
| logs   | The location for the logs created by Auditbeat. | `{path.home}/logs` | `path.logs`   |

You can change these settings by using CLI flags or setting [path options](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-path) in the configuration file.

## Default paths

Auditbeat uses the following default paths unless you explicitly change them.

#### deb and rpm


| Type   | Description                                     | Location                   |
|--------|-------------------------------------------------|----------------------------|
| home   | Home of the Auditbeat installation.             | `/usr/share/auditbeat`     |
| bin    | The location for the binary files.              | `/usr/share/auditbeat/bin` |
| config | The location for configuration files.           | `/etc/auditbeat`           |
| data   | The location for persistent data files.         | `/var/lib/auditbeat`       |
| logs   | The location for the logs created by Auditbeat. | `/var/log/auditbeat`       |

For the deb and rpm distributions, these paths are set in the init script or in the systemd unit file.  Make sure that you start the Auditbeat service by using the preferred operating system method (init scripts or `systemctl`). Otherwise the paths might be set incorrectly.

#### docker


| Type   | Description                                     | Location                    |
|--------|-------------------------------------------------|-----------------------------|
| home   | Home of the Auditbeat installation.             | `/usr/share/auditbeat`      |
| bin    | The location for the binary files.              | `/usr/share/auditbeat`      |
| config | The location for configuration files.           | `/usr/share/auditbeat`      |
| data   | The location for persistent data files.         | `/usr/share/auditbeat/data` |
| logs   | The location for the logs created by Auditbeat. | `/usr/share/auditbeat/logs` |


#### zip, tar.gz, or tgz


| Type   | Description                                     | Location              |
|--------|-------------------------------------------------|-----------------------|
| home   | Home of the Auditbeat installation.             | `{extract.path}`      |
| bin    | The location for the binary files.              | `{extract.path}`      |
| config | The location for configuration files.           | `{extract.path}`      |
| data   | The location for persistent data files.         | `{extract.path}/data` |
| logs   | The location for the logs created by Auditbeat. | `{extract.path}/logs` |

For the zip, tar.gz, or tgz distributions, these paths are based on the location of the extracted binary file. This means that if you start Auditbeat with the following simple command, all paths are set correctly:
```sh
./auditbeat
```