﻿---
title: Define processors
description: You can use processors to filter and enhance data before sending it to the configured output. To define a processor, you specify the processor name, an...
url: https://www.elastic.co/docs/reference/beats/auditbeat/defining-processors
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Define processors
You can use processors to filter and enhance data before sending it to the configured output. To define a processor, you specify the processor name, an optional condition, and a set of parameters:
```yaml
processors:
  - <processor_name>:
      when:
        <condition>
      <parameters>

  - <processor_name>:
      when:
        <condition>
      <parameters>

...
```

Where:
- `<processor_name>` specifies a [processor](#processors) that performs some kind of action, such as selecting the fields that are exported or adding metadata to the event.
- `<condition>` specifies an optional [condition](#conditions). If the condition is present, then the action is executed only if the condition is fulfilled. If no condition is set, then the action is always executed.
- `<parameters>` is the list of parameters to pass to the processor.

More complex conditional processing can be accomplished by using the if-then-else processor configuration. This allows multiple processors to be executed based on a single condition.
```yaml
processors:
  - if:
      <condition>
    then: 
      - <processor_name>:
          <parameters>
      - <processor_name>:
          <parameters>
      ...
    else: 
      - <processor_name>:
          <parameters>
      - <processor_name>:
          <parameters>
      ...
```


## Where are processors valid?

Processors are valid:
- At the top-level in the configuration. The processor is applied to all data collected by Auditbeat.
- Under a specific module. The processor is applied to the data collected for that module.
  ```yaml
  auditbeat.modules:
  - module: <module_name>
    processors:
      - <processor_name>:
          when:
            <condition>
          <parameters>
  ```


## Processors

The supported processors are:
- [`add_cloud_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-cloud-metadata)
- [`add_cloudfoundry_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-cloudfoundry-metadata)
- [`add_docker_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-docker-metadata)
- [`add_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/add-fields)
- [`add_host_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-host-metadata)
- [`add_id`](https://www.elastic.co/docs/reference/beats/auditbeat/add-id)
- [`add_kubernetes_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-kubernetes-metadata)
- [`add_labels`](https://www.elastic.co/docs/reference/beats/auditbeat/add-labels)
- [`add_locale`](https://www.elastic.co/docs/reference/beats/auditbeat/add-locale)
- [`add_nomad_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-nomad-metadata)
- [`add_observer_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-observer-metadata)
- [`add_process_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-process-metadata)
- [`add_session_metadata`](https://www.elastic.co/docs/reference/beats/auditbeat/add-session-metadata)
- [`add_tags`](https://www.elastic.co/docs/reference/beats/auditbeat/add-tags)
- [`append`](https://www.elastic.co/docs/reference/beats/auditbeat/append)
- [`community_id`](https://www.elastic.co/docs/reference/beats/auditbeat/community-id)
- [`convert`](https://www.elastic.co/docs/reference/beats/auditbeat/convert)
- [`copy_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/copy-fields)
- [`decode_base64_field`](https://www.elastic.co/docs/reference/beats/auditbeat/decode-base64-field)
- [`decode_duration`](https://www.elastic.co/docs/reference/beats/auditbeat/decode-duration)
- [`decode_json_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/decode-json-fields)
- [`decode_xml`](https://www.elastic.co/docs/reference/beats/auditbeat/decode-xml)
- [`decode_xml_wineventlog`](https://www.elastic.co/docs/reference/beats/auditbeat/decode-xml-wineventlog)
- [`decompress_gzip_field`](https://www.elastic.co/docs/reference/beats/auditbeat/decompress-gzip-field)
- [`detect_mime_type`](https://www.elastic.co/docs/reference/beats/auditbeat/detect-mime-type)
- [`dissect`](https://www.elastic.co/docs/reference/beats/auditbeat/dissect)
- [`dns`](https://www.elastic.co/docs/reference/beats/auditbeat/processor-dns)
- [`drop_event`](https://www.elastic.co/docs/reference/beats/auditbeat/drop-event)
- [`drop_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/drop-fields)
- [`extract_array`](https://www.elastic.co/docs/reference/beats/auditbeat/extract-array)
- [`fingerprint`](https://www.elastic.co/docs/reference/beats/auditbeat/fingerprint)
- [`include_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/include-fields)
- [`move-fields`](https://www.elastic.co/docs/reference/beats/auditbeat/move-fields)
- [`now`](https://www.elastic.co/docs/reference/beats/auditbeat/now) <applies-to>Elastic Stack: Generally available since 9.1</applies-to>
- [`rate_limit`](https://www.elastic.co/docs/reference/beats/auditbeat/rate-limit)
- [`registered_domain`](https://www.elastic.co/docs/reference/beats/auditbeat/processor-registered-domain)
- [`rename`](https://www.elastic.co/docs/reference/beats/auditbeat/rename-fields)
- [`replace`](https://www.elastic.co/docs/reference/beats/auditbeat/replace-fields)
- [`syslog`](https://www.elastic.co/docs/reference/beats/auditbeat/syslog)
- [`translate_ldap_attribute`](https://www.elastic.co/docs/reference/beats/auditbeat/processor-translate-guid)
- [`translate_sid`](https://www.elastic.co/docs/reference/beats/auditbeat/processor-translate-sid)
- [`truncate_fields`](https://www.elastic.co/docs/reference/beats/auditbeat/truncate-fields)
- [`urldecode`](https://www.elastic.co/docs/reference/beats/auditbeat/urldecode)


## Conditions

Each condition receives a field to compare. You can specify multiple fields under the same condition by using `AND` between the fields (for example, `field1 AND field2`).
For each field, you can specify a simple field name or a nested map, for example `dns.question.name`.
See [Exported fields](https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields) for a list of all the fields that are exported by Auditbeat.
The supported conditions are:
- [`equals`](#condition-equals)
- [`contains`](#condition-contains)
- [`regexp`](#condition-regexp)
- [`range`](#condition-range)
- [`network`](#condition-network)
- [`has_fields`](#condition-has_fields)
- [`or`](#condition-or)
- [`and`](#condition-and)
- [`not`](#condition-not)


#### `equals`

With the `equals` condition, you can compare if a field has a certain value. The condition accepts only an integer or a string value.
For example, the following condition checks if the response code of the HTTP transaction is 200:
```yaml
equals:
  http.response.code: 200
```


#### `contains`

The `contains` condition checks if a value is part of a field. The field can be a string or an array of strings. The condition accepts only a string value.
For example, the following condition checks if an error is part of the transaction status:
```yaml
contains:
  status: "Specific error"
```


#### `regexp`

The `regexp` condition checks the field against a regular expression. The condition accepts only strings.
For example, the following condition checks if the process name starts with `foo`:
```yaml
regexp:
  system.process.name: "^foo.*"
```


#### `range`

The `range` condition checks if the field is in a certain range of values. The condition supports `lt`, `lte`, `gt` and `gte`. The condition accepts only integer, float, or strings that can be converted to either of these as values.
For example, the following condition checks for failed HTTP transactions by comparing the `http.response.code` field with 400.
```yaml
range:
  http.response.code:
    gte: 400
```

This can also be written as:
```yaml
range:
  http.response.code.gte: 400
```

The following condition checks if the CPU usage in percentage has a value between 0.5 and 0.8.
```yaml
range:
  system.cpu.user.pct.gte: 0.5
  system.cpu.user.pct.lt: 0.8
```


#### `network`

The `network` condition checks whether a field’s value falls within a specified IP network range. If multiple fields are provided, each field value must match its corresponding network range. You can specify multiple network ranges for a single field, and a match occurs if any one of the ranges matches. If the field value is an array of IPs, it will match if any of the IPs fall within any of the given ranges. Both IPv4 and IPv6 addresses are supported.
The network range may be specified using CIDR notation, like "192.0.2.0/24" or "2001:db8::/32", or by using one of these named ranges:
- `loopback` - Matches loopback addresses in the range of `127.0.0.0/8` or `::1/128`.
- `unicast` - Matches global unicast addresses defined in RFC 1122, RFC 4632, and RFC 4291 with the exception of the IPv4 broadcast address (`255.255.255.255`). This includes private address ranges.
- `multicast` - Matches multicast addresses.
- `interface_local_multicast` - Matches IPv6 interface-local multicast addresses.
- `link_local_unicast` - Matches link-local unicast addresses.
- `link_local_multicast` - Matches link-local multicast addresses.
- `private` - Matches private address ranges defined in RFC 1918 (IPv4) and RFC 4193 (IPv6).
- `public` - Matches addresses that are not loopback, unspecified, IPv4 broadcast, link local unicast, link local multicast, interface local multicast, or private.
- `unspecified` - Matches unspecified addresses (either the IPv4 address "0.0.0.0" or the IPv6 address "::").

The following condition returns true if the `source.ip` value is within the private address space.
```yaml
network:
  source.ip: private
```

This condition returns true if the `destination.ip` value is within the IPv4 range of `192.168.1.0` - `192.168.1.255`.
```yaml
network:
  destination.ip: '192.168.1.0/24'
```

And this condition returns true when `destination.ip` is within any of the given subnets.
```yaml
network:
  destination.ip: ['192.168.1.0/24', '10.0.0.0/8', loopback]
```


#### `has_fields`

The `has_fields` condition checks if all the given fields exist in the event. The condition accepts a list of string values denoting the field names.
For example, the following condition checks if the `http.response.code` field is present in the event.
```yaml
has_fields: ['http.response.code']
```


#### `or`

The `or` operator receives a list of conditions.
```yaml
or:
  - <condition1>
  - <condition2>
  - <condition3>
  ...
```

For example, to configure the condition `http.response.code = 304 OR http.response.code = 404`:
```yaml
or:
  - equals:
      http.response.code: 304
  - equals:
      http.response.code: 404
```


#### `and`

The `and` operator receives a list of conditions.
```yaml
and:
  - <condition1>
  - <condition2>
  - <condition3>
  ...
```

For example, to configure the condition `http.response.code = 200 AND status = OK`:
```yaml
and:
  - equals:
      http.response.code: 200
  - equals:
      status: OK
```

To configure a condition like `<condition1> OR <condition2> AND <condition3>`:
```yaml
or:
  - <condition1>
  - and:
    - <condition2>
    - <condition3>
```


#### `not`

The `not` operator receives the condition to negate.
```yaml
not:
  <condition>
```

For example, to configure the condition `NOT status = OK`:
```yaml
not:
  equals:
    status: OK
```