﻿---
title: Decode duration
description: The decode_duration processor decodes a Go-style duration string into a specific format. For more information about the Go time.Duration string style,...
url: https://www.elastic.co/docs/reference/beats/auditbeat/decode-duration
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Decode duration
The `decode_duration` processor decodes a Go-style duration string into a specific `format`.
For more information about the Go `time.Duration` string style, refer to the [Go documentation](https://pkg.go.dev/time#Duration).

| Name     | Required | Default        | Description                                                   |
|----------|----------|----------------|---------------------------------------------------------------|
| `field`  | yes      |                | Which field of event needs to be decoded as `time.Duration`   |
| `format` | yes      | `milliseconds` | Supported formats: `milliseconds`/`seconds`/`minutes`/`hours` |

```yaml
processors:
  - decode_duration:
      field: "app.rpc.cost"
      format: "milliseconds"
```