﻿---
title: Copy fields
description: The copy_fields processor takes the value of a field and copies it to a new field. You cannot use this processor to replace an existing field. If the...
url: https://www.elastic.co/docs/reference/beats/auditbeat/copy-fields
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Copy fields
The `copy_fields` processor takes the value of a field and copies it to a new field.
You cannot use this processor to replace an existing field. If the target field already exists, you must [drop](https://www.elastic.co/docs/reference/beats/auditbeat/drop-fields) or [rename](https://www.elastic.co/docs/reference/beats/auditbeat/rename-fields) the field before using `copy_fields`.
<definitions>
  <definition term="fields">
    List of `from` and `to` pairs to copy from and to. It’s supported to use `@metadata.` prefix for `from` and `to` and copy values not just in/from/to the event fields but also in/from/to the event metadata.
  </definition>
  <definition term="fail_on_error">
    (Optional) If set to `true` and an error occurs, the changes are reverted and the original is returned. If set to `false`, processing continues if an error occurs. Default is `true`.
  </definition>
  <definition term="ignore_missing">
    (Optional) Indicates whether to ignore events that lack the source field. The default is `false`, which will fail processing of an event if a field is missing.
  </definition>
</definitions>

For example, this configuration:
```yaml
processors:
  - copy_fields:
      fields:
        - from: message
          to: event.original
      fail_on_error: false
      ignore_missing: true
```

Copies the original `message` field to `event.original`:
```json
{
  "message": "my-interesting-message",
  "event": {
      "original": "my-interesting-message"
  }
}
```