﻿---
title: Configure Auditbeat
description: To configure Auditbeat, edit the configuration file. The default configuration file is called  auditbeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/auditbeat/configuring-howto-auditbeat
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure Auditbeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration).
</tip>

To configure Auditbeat, edit the configuration file. The default configuration file is called  `auditbeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/auditbeat/directory-layout).
There’s also a full example configuration file called `auditbeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Auditbeat:
- [Modules](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-auditbeat)
- [General settings](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-path)
- [Config file reloading](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-configuration-reloading)
- [Output](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/auditbeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-template)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/auditbeat/setup-kibana-endpoint)
- [Kibana dashboards](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-dashboards)
- [Processors](https://www.elastic.co/docs/reference/beats/auditbeat/filtering-enhancing-data)
- [Internal queue](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/auditbeat/http-endpoint)
- [*Regular expression support*](https://www.elastic.co/docs/reference/beats/auditbeat/regexp-support)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-instrumentation)
- [Feature flags](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-feature-flags)
- [*auditbeat.reference.yml*](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-reference-yml)

After changing configuration settings, you need to restart Auditbeat to pick up the changes.