﻿---
title: Configure Elasticsearch index template loading
description: The setup.template section of the auditbeat.yml config file specifies the index template to use for setting mappings in Elasticsearch. If template loading...
url: https://www.elastic.co/docs/reference/beats/auditbeat/configuration-template
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure Elasticsearch index template loading
The `setup.template` section of the `auditbeat.yml` config file specifies the [index template](https://www.elastic.co/docs/manage-data/data-store/templates) to use for setting mappings in Elasticsearch. If template loading is enabled (the default), Auditbeat loads the index template automatically after successfully connecting to Elasticsearch.
<note>
  A connection to Elasticsearch is required to load the index template. If the configured output is not Elasticsearch (or Elastic Cloud Hosted), you must [load the template manually](/docs/reference/beats/auditbeat/auditbeat-template#load-template-manually).
</note>

You can adjust the following settings to load your own template or overwrite an existing one.
<definitions>
  <definition term="setup.template.enabled">
    Set to false to disable template loading. If this is set to false, you must [load the template manually](/docs/reference/beats/auditbeat/auditbeat-template#load-template-manually).
  </definition>
  <definition term="setup.template.name">
    The name of the template. The default is `auditbeat`. The Auditbeat version is always appended to the given name, so the final name is `auditbeat-%{[agent.version]}`.
  </definition>
  <definition term="setup.template.pattern">
    The template pattern to apply to the default index settings. The default pattern is `auditbeat`. The Auditbeat version is always included in the pattern, so the final pattern is `auditbeat-%{[agent.version]}`.
    Example:
    ```yaml
    setup.template.name: "auditbeat"
    setup.template.pattern: "auditbeat"
    ```
  </definition>
  <definition term="setup.template.fields">
    The path to the YAML file describing the fields. The default is `fields.yml`. If a relative path is set, it is considered relative to the config path. See the [Directory layout](https://www.elastic.co/docs/reference/beats/auditbeat/directory-layout) section for details.
  </definition>
  <definition term="setup.template.overwrite">
    A boolean that specifies whether to overwrite the existing template. The default is false. Do not enable this option if you start more than one instance of Auditbeat at the same time. It can overload Elasticsearch by sending too many template update requests.
  </definition>
  <definition term="setup.template.settings">
    A dictionary of settings to place into the `settings.index` dictionary of the Elasticsearch template. For more details about the available Elasticsearch mapping options, please see the Elasticsearch [mapping reference](https://www.elastic.co/docs/manage-data/data-store/mapping).
    Example:
    ```yaml
    setup.template.name: "auditbeat"
    setup.template.fields: "fields.yml"
    setup.template.overwrite: false
    setup.template.settings:
      index.number_of_shards: 1
      index.number_of_replicas: 1
    ```
  </definition>
  <definition term="setup.template.settings._source">
    A dictionary of settings for the `_source` field. For the available settings, please see the Elasticsearch [reference](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field).
    Example:
    ```yaml
    setup.template.name: "auditbeat"
    setup.template.fields: "fields.yml"
    setup.template.overwrite: false
    setup.template.settings:
      _source.enabled: false
    ```
  </definition>
  <definition term="setup.template.append_fields">
    A list of fields to be added to the template and Kibana index pattern. This setting adds new fields. It does not overwrite or change existing fields.
    This setting is useful when your data contains fields that Auditbeat doesn’t know about in advance.
    If `append_fields` is specified along with `overwrite: true`, Auditbeat overwrites the existing template and applies the new template when creating new indices. Existing indices are not affected. If you’re running multiple instances of Auditbeat with different `append_fields` settings, the last one writing the template takes precedence.
    Any changes to this setting also affect the Kibana index pattern.
    Example config:
    ```yaml
    setup.template.overwrite: true
    setup.template.append_fields:
    - name: test.name
      type: keyword
    - name: test.hostname
      type: long
    ```
  </definition>
  <definition term="setup.template.json.enabled">
    Set to `true` to load a JSON-based template file. Specify the path to your Elasticsearch index template file and set the name of the template.
    ```yaml
    setup.template.json.enabled: true
    setup.template.json.path: "template.json"
    setup.template.json.name: "template-name"
    setup.template.json.data_stream: false
    ```
  </definition>
</definitions>

<note>
  If the JSON template is used, the `fields.yml` is skipped for the template generation.
</note>

<note>
  If the JSON template is a data stream, set `setup.template.json.data_stream`.
</note>