﻿---
title: Configure APM instrumentation
description: Libbeat uses the Elastic APM Go Agent to instrument its publishing pipeline. Currently, only the Elasticsearch output is instrumented. To gain insight...
url: https://www.elastic.co/docs/reference/beats/auditbeat/configuration-instrumentation
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure APM instrumentation
Libbeat uses the Elastic APM Go Agent to instrument its publishing pipeline. Currently, only the Elasticsearch output is instrumented. To gain insight into the performance of Auditbeat, you can enable this instrumentation and send trace data to the APM Integration.
Example configuration with instrumentation enabled:
```yaml
instrumentation:
  enabled: true
  environment: production
  hosts:
    - "http://localhost:8200"
  api_key: L5ER6FEvjkmlfalBealQ3f3fLqf03fazfOV
```


## Configuration options

You can specify the following options in the `instrumentation` section of the `auditbeat.yml` config file:

### `enabled`

Set to `true` to enable instrumentation of Auditbeat. Defaults to `false`.

### `environment`

Set the environment in which Auditbeat is running, for example, `staging`, `production`, `dev`, etc. Environments can be filtered in the [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews).

### `hosts`

The APM integration [host](https://www.elastic.co/docs/reference/apm/observability/apm-settings) to report instrumentation data to. Defaults to `http://localhost:8200`.

### `api_key`

The [API Key](https://www.elastic.co/docs/reference/apm/observability/apm-settings) used to secure communication with the APM Integration. If `api_key` is set then `secret_token` will be ignored.

### `secret_token`

The [Secret token](https://www.elastic.co/docs/reference/apm/observability/apm-settings) used to secure communication with the APM Integration.

### `profiling.cpu.enabled`

Set to `true` to enable CPU profiling, where profile samples are recorded as events.
This feature is experimental.

### `profiling.cpu.interval`

Configure the CPU profiling interval. Defaults to `60s`.
This feature is experimental.

### `profiling.cpu.duration`

Configure the CPU profiling duration. Defaults to `10s`.
This feature is experimental.

### `profiling.heap.enabled`

Set to `true` to enable heap profiling.
This feature is experimental.

### `profiling.heap.interval`

Configure the heap profiling interval. Defaults to `60s`.
This feature is experimental.