﻿---
title: Configure modules
description: To enable specific modules you add entries to the auditbeat.modules list in the auditbeat.yml config file. Each entry in the list begins with a dash (-)...
url: https://www.elastic.co/docs/reference/beats/auditbeat/configuration-auditbeat
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Configure modules
To enable specific modules you add entries to the `auditbeat.modules` list in the `auditbeat.yml` config file. Each entry in the list begins with a dash (-) and is followed by settings for that module.
The following example shows a configuration that runs the `auditd` and `file_integrity` modules.
```yaml
auditbeat.modules:

- module: auditd
  audit_rules: |
    -w /etc/passwd -p wa -k identity
    -a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EPERM -k access

- module: file_integrity
  paths:
  - /bin
  - /usr/bin
  - /sbin
  - /usr/sbin
  - /etc
```

The configuration details vary by module. See the [module documentation](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-modules) for more detail about configuring the available modules.