﻿---
title: Change the index name
description: Auditbeat uses data streams named auditbeat-[version]. To use a different name, set the index option in the Elasticsearch output. You also need to configure...
url: https://www.elastic.co/docs/reference/beats/auditbeat/change-index-name
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Change the index name
Auditbeat uses data streams named `auditbeat-[version]`. To use a different name, set the [`index`](/docs/reference/beats/auditbeat/elasticsearch-output#index-option-es) option in the Elasticsearch output. You also need to configure the `setup.template.name` and `setup.template.pattern` options to match the new name. For example:
```sh
output.elasticsearch.index: "customname-%{[agent.version]}"
setup.template.name: "customname-%{[agent.version]}"
setup.template.pattern: "customname-%{[agent.version]}"
```

If you’re using pre-built Kibana dashboards, also set the `setup.dashboards.index` option. For example:
```yaml
setup.dashboards.index: "customname-*"
```

For a full list of template setup options, see [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/auditbeat/configuration-template).