﻿---
title: Start Auditbeat
description: Before starting Auditbeat: Follow the steps in Quick start: installation and configuration to install, configure, and set up the Auditbeat environment.Make...
url: https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-starting
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Start Auditbeat
Before starting Auditbeat:
- Follow the steps in [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration) to install, configure, and set up the Auditbeat environment.
- Make sure Kibana and Elasticsearch are running.
- Make sure the user specified in `auditbeat.yml` is [authorized to publish events](https://www.elastic.co/docs/reference/beats/auditbeat/privileges-to-publish-events).

To start Auditbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service auditbeat start
    ```
    Also see [Auditbeat and systemd](https://www.elastic.co/docs/reference/beats/auditbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service auditbeat start
    ```
    Also see [Auditbeat and systemd](https://www.elastic.co/docs/reference/beats/auditbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root auditbeat.yml 
    sudo ./auditbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root auditbeat.yml 
    sudo ./auditbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\auditbeat> Start-Service auditbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Auditbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\auditbeat\logs`.
    </note>
  </tab-item>
</tab-set>