﻿---
title: Auditbeat quick start: installation and configuration
description: This guide describes how to get started quickly with audit data collection. You’ll learn how to: install Auditbeat on each system you want to monitor,...
url: https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Auditbeat quick start: installation and configuration
This guide describes how to get started quickly with audit data collection. You’ll learn how to:
- install Auditbeat on each system you want to monitor
- specify the location of your audit data
- parse log data into fields and send it to Elasticsearch
- visualize the log data in Kibana

![Auditbeat Auditd dashboard](https://www.elastic.co/docs/reference/beats/auditbeat/images/auditbeat-auditd-dashboard.png)

## Before you begin

You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
</applies-switch>


## Step 1: Install Auditbeat

Install Auditbeat on all the servers you want to monitor.
To download and install Auditbeat, use the commands that work with your system:
<tab-set>
  <tab-item title="DEB">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/auditbeat/auditbeat-9.3.0-amd64.deb
    sudo dpkg -i auditbeat-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/auditbeat/auditbeat-9.3.0-x86_64.rpm
    sudo rpm -vi auditbeat-9.3.0-x86_64.rpm
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/auditbeat/auditbeat-9.3.0-darwin-x86_64.tar.gz
    tar xzvf auditbeat-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/auditbeat/auditbeat-9.3.0-linux-x86_64.tar.gz
    tar xzvf auditbeat-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    1. Download the [Auditbeat Windows zip file](https://artifacts.elastic.co/downloads/beats/auditbeat/auditbeat-9.3.0-windows-x86_64.zip).
    2. Extract the contents of the zip file into `C:\Program Files`.
    3. Rename the `auditbeat-[version]-windows-x86_64` directory to `Auditbeat`.
    4. Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select *Run As Administrator*).
    5. From the PowerShell prompt, run the following commands to install Auditbeat as a Windows service:

    ```shell
    PS > cd 'C:\Program Files\Auditbeat'
    PS C:\Program Files\Auditbeat> .\install-service-auditbeat.ps1
    ```

    <note>
      If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-auditbeat.ps1`.
    </note>

    <important applies-to="Elastic Stack: Generally available since 9.0.6">
      The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
      because the latter has stricter permissions. The home path (base for
      state and logs) is now `C:\Program Files\Auditbeat-Data`.The install script (`install-service-auditbeat.ps1`) will check whether
      `C:\ProgramData\Auditbeat` exits and move it to `C:\Program Files\Auditbeat-Data`.
      For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-script).
    </important>
  </tab-item>
</tab-set>

The commands shown are for AMD platforms, but ARM packages are also available. Refer to the [download page](https://www.elastic.co/downloads/beats/auditbeat) for the full list of available packages.

### Other installation options

- [APT or YUM](https://www.elastic.co/docs/reference/beats/auditbeat/setup-repositories)
- [Download page](https://www.elastic.co/downloads/beats/auditbeat)
- [Docker](https://www.elastic.co/docs/reference/beats/auditbeat/running-on-docker)
- [Kubernetes](https://www.elastic.co/docs/reference/beats/auditbeat/running-on-kubernetes)


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Auditbeat.
Set the connection information in `auditbeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/auditbeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/auditbeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/auditbeat/configure-cloud-id) to a user who is authorized to set up Auditbeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "auditbeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Auditbeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Auditbeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "auditbeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" <2> 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/auditbeat/feature-roles).
<note>
  You can send data to other [outputs](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-output), such as Logstash, but that requires additional configuration and setup.
</note>


## Step 3: Configure data collection modules

Auditbeat uses [modules](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-modules) to collect audit information.
By default, Auditbeat uses a configuration that’s tailored to the operating system where Auditbeat is running.
To use a different configuration, change the module settings in `auditbeat.yml`.
The following example shows the `file_integrity` module configured to generate events whenever a file in one of the specified paths changes on disk:
```sh
auditbeat.modules:

- module: file_integrity
  paths:
  - /bin
  - /usr/bin
  - /sbin
  - /usr/sbin
  - /etc
```

<tip>
  To test your configuration file, change to the directory where the Auditbeat binary is installed, and run Auditbeat in the foreground with the following options specified: `./auditbeat test config -e`. Make sure your config files are in the path expected by Auditbeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/auditbeat/directory-layout)), or use the `-c` flag to specify the path to the config file.
</tip>

For more information about configuring Auditbeat, also see:
- [Configure Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/configuring-howto-auditbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`auditbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `auditbeat.yml`.


## Step 4: Set up assets

Auditbeat comes with predefined assets for parsing, indexing, and visualizing your data. To load these assets:
1. Make sure the user specified in `auditbeat.yml` is [authorized to set up Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/privileges-to-setup-beats).
2. From the installation directory, run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   auditbeat setup -e
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   auditbeat setup -e
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./auditbeat setup -e
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./auditbeat setup -e
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\auditbeat.exe setup -e
   ```
   </tab-item>
   </tab-set>
   `-e` is optional and sends output to standard error instead of the configured log output.

By default Windows log files are stored in `C:\Program Files\Auditbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\auditbeat\logs`.
</note>

This step loads the recommended [index template](https://www.elastic.co/docs/manage-data/data-store/templates) for writing to Elasticsearch and deploys the sample dashboards for visualizing the data in Kibana.
<tip>
  A connection to Elasticsearch (or Elastic Cloud Hosted) is required to set up the initial environment. If you're using a different output, such as Logstash, see [Load the Elasticsearch index template > Load the index template manually](/docs/reference/beats/auditbeat/auditbeat-template#load-template-manually) and [Load Kibana dashboards](https://www.elastic.co/docs/reference/beats/auditbeat/load-kibana-dashboards).
</tip>


## Step 5: Start Auditbeat

Before starting Auditbeat, modify the user credentials in `auditbeat.yml` and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/auditbeat/privileges-to-publish-events).
To start Auditbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service auditbeat start
    ```

    <note>
      If you use an `init.d` script to start Auditbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Auditbeat in the foreground.
    </note>
    Also see [Auditbeat and systemd](https://www.elastic.co/docs/reference/beats/auditbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service auditbeat start
    ```

    <note>
      If you use an `init.d` script to start Auditbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/filebeat/command-line-options)). To specify flags, start Auditbeat in the foreground.
    </note>
    Also see [Auditbeat and systemd](https://www.elastic.co/docs/reference/beats/auditbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root auditbeat.yml 
    sudo ./auditbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root auditbeat.yml 
    sudo ./auditbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\auditbeat> Start-Service auditbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Auditbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\auditbeat\logs`.
    </note>
  </tab-item>
</tab-set>

Auditbeat should begin streaming events to Elasticsearch.
If you see a warning about too many open files, you need to increase the `ulimit`. See the [FAQ](https://www.elastic.co/docs/reference/beats/auditbeat/ulimit) for more details.

## Step 6: View your data in Kibana

To make it easier for you to start auditing the activities of users and processes on your system, Auditbeat comes with pre-built Kibana dashboards and UIs for visualizing your data.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Auditbeat data, make sure the predefined `auditbeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.

## What’s next?

Now that you have audit data streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) | Infrastructure metrics          |
   | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)       | Logs                            |
   | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) | Windows event logs              |
   | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration)    | Uptime information              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |