﻿---
title: System user dataset
description: This is the user dataset of the system module. It is implemented for Linux only. The dataset comes with a sample dashboard: Auditbeat System User Dashboard...
url: https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-user
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Beta
---

# System user dataset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the `user` dataset of the system module.
It is implemented for Linux only.

### Example dashboard

The dataset comes with a sample dashboard:
![Auditbeat System User Dashboard](https://www.elastic.co/docs/reference/beats/auditbeat/images/auditbeat-system-user-dashboard.png)

## Fields

For a description of each field in the dataset, see the [exported fields](https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-system) section.
Here is an example document generated by this dataset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "action": "user_added",
        "dataset": "user",
        "kind": "event",
        "module": "system"
    },
    "message": "New user elastic (UID: 1001, Groups: elastic,docker)",
    "service": {
        "type": "system"
    },
    "system": {
        "audit": {
            "user": {
                "dir": "/home/elastic",
                "gid": "1001",
                "group": [
                    {
                        "gid": "1001",
                        "name": "elastic"
                    },
                    {
                        "gid": "1002",
                        "name": "docker"
                    }
                ],
                "name": "elastic",
                "shell": "/bin/bash",
                "uid": "1001"
            }
        }
    },
    "user": {
        "entity_id": "FgDfgeDptvvfdX+L",
        "id": "1001",
        "name": "elastic"
    }
}
```