﻿---
title: System package dataset
description: This is the package dataset of the system module. It is implemented for Linux distributions using dpkg or rpm as their package manager, and for Homebrew...
url: https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-package
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Beta
---

# System package dataset
This is the `package` dataset of the system module.
It is implemented for Linux distributions using dpkg or rpm as their package manager, and for Homebrew on macOS (Darwin).

### Example dashboard

The dataset comes with a sample dashboard:
![Auditbeat System Package Dashboard](https://www.elastic.co/docs/reference/beats/auditbeat/images/auditbeat-system-package-dashboard.png)

## Fields

For a description of each field in the dataset, see the [exported fields](https://www.elastic.co/docs/reference/beats/auditbeat/exported-fields-system) section.
Here is an example document generated by this dataset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "action": "existing_package",
        "category": [
            "package"
        ],
        "dataset": "package",
        "id": "6bed65c5-9797-4fb7-9ec7-2d1873c54371",
        "kind": "state",
        "module": "system",
        "type": [
            "info"
        ]
    },
    "message": "Package zstd (1.5.4) is already installed",
    "package": {
        "description": "Zstandard is a real-time compression algorithm",
        "installed": "2023-02-15T20:40:24.390086982-05:00",
        "name": "zstd",
        "reference": "https://facebook.github.io/zstd/",
        "type": "brew",
        "version": "1.5.4"
    },
    "service": {
        "type": "system"
    },
    "system": {
        "audit": {
            "package": {
                "entity_id": "SxYD3ZMh/Ym0lBIk",
                "installtime": "2023-02-15T20:40:24.390086982-05:00",
                "name": "zstd",
                "summary": "Zstandard is a real-time compression algorithm",
                "url": "https://facebook.github.io/zstd/",
                "version": "1.5.4"
            }
        }
    }
}
```