﻿---
title: Add session metadata
description: The add_session_metadata processor enriches process events with additional information that users can see using the Session View tool in the Elastic Security...
url: https://www.elastic.co/docs/reference/beats/auditbeat/add-session-metadata
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Add session metadata
The `add_session_metadata` processor enriches process events with additional information that users can see using the [Session View](https://www.elastic.co/docs/solutions/security/investigate/session-view) tool in the Elastic Security platform.
<note>
  The current release of `add_session_metadata` processor for Auditbeat is limited to virtual machines (VMs) and bare metal environments.
</note>

Here’s an example using the `add_session_metadata` processor to enhance process events generated by the `auditd` module of Auditbeat.
```yaml
auditbeat.modules:
- module: auditd
  processors:
    - add_session_metadata:
       backend: "auto"
```


## How the `add_session_metadata` processor works

Using the available Linux kernel technology, the processor collects comprehensive information on all running system processes, compiling this data into a process database. When processing an event (such as those generated by the Auditbeat `auditd` module), the processor queries this database to retrieve information about related processes, including the parent process, session leader, process group leader, and entry leader. It then enriches the original event with this metadata, providing a more complete picture of process relationships and system activities.
This enhanced data enables the powerful [Session View](https://www.elastic.co/docs/solutions/security/investigate/session-view) tool in the Elastic Security platform, offering users deeper insights for analysis and investigation.

### Backends

The `add_session_metadata` processor operates using various backend options.
- `auto` is the recommended setting. It attempts to use `kernel_tracing` first, falling back to `procfs` if necessary, ensuring compatibility even on systems without `kernel_tracing` support.
- `kernel_tracing` gathers information about processes using either eBPF or kprobes. It will use eBPF if available, but if not, it will fall back to kprobes. eBPF requires a system with kernel support for eBPF enabled, support for eBPF ring buffer, and auditbeat running as superuser. Kprobe support requires Linux kernel 3.10.0 or above, and auditbeat running as a superuser.
- `procfs` collects process information with the proc filesystem. This is compatible with older systems that may not support ebpf. To gather complete process info, auditbeat requires permissions to read all process data in procfs; for example, run as a superuser or have the `SYS_PTRACE` capability.


### Containers

If you are running Auditbeat in a container, the container must run in the host’s PID namespace. With the `auto` or `kernel_tracing` backend, these host directories must also be mounted to the same path within the container: `/sys/kernel/debug`, `/sys/fs/bpf`.

## Enable and configure Session View in Auditbeat

To configure and enable [Session View](https://www.elastic.co/docs/solutions/security/investigate/session-view) functionality, you’ll:
- Add the `add_sessions_metadata` processor to your `auditbeat.yml` file.
- Configure audit rules in your `auditbeat.yml` file.
- Restart Auditbeat.

We’ll walk you through these steps in more detail.
1. Edit your `auditbeat.yml` file and add this info to the modules configuration section:
   ```yaml
   auditbeat.modules:
   - module: auditd
     processors:
       - add_session_metadata:
          backend: "auto"
   ```
2. Add audit rules in the modules configuration section of `auditbeat.yml` or the `audit.rules.d` config file, depending on your configuration:
   ```yaml
   auditbeat.modules:
   - module: auditd
     audit_rules: |
       ## executions
       -a always,exit -F arch=b64 -S execve,execveat -k exec
       -a always,exit -F arch=b64 -S exit_group
       ## set_sid
       -a always,exit -F arch=b64 -S setsid
   ```
3. Save your configuration changes.
4. Restart Auditbeat:
   ```sh
   sudo systemctl restart auditbeat
   ```