﻿---
title: Add labels
description: The add_labels processors adds a set of key-value pairs to an event. The processor will flatten nested configuration objects like arrays or dictionaries...
url: https://www.elastic.co/docs/reference/beats/auditbeat/add-labels
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Add labels
The `add_labels` processors adds a set of key-value pairs to an event. The processor will flatten nested configuration objects like arrays or dictionaries into a fully qualified name by merging nested names with a `.`. Array entries create numeric names starting with 0.  Labels are always stored under the Elastic Common Schema compliant `labels` sub-dictionary.
<definitions>
  <definition term="labels">
    dictionaries of labels to be added.
  </definition>
</definitions>

For example, this configuration:
```yaml
processors:
  - add_labels:
      labels:
        number: 1
        with.dots: test
        nested:
          with.dots: nested
        array:
          - do
          - re
          - with.field: mi
```

Adds these fields to every event:
```json
{
  "labels": {
    "number": 1,
    "with.dots": "test",
    "nested.with.dots": "nested",
    "array.0": "do",
    "array.1": "re",
    "array.2.with.field": "mi"
  }
}
```