﻿---
title: Generate an ID for an event
description: The add_id processor generates a unique ID for an event. The following settings are supported: 
url: https://www.elastic.co/docs/reference/beats/auditbeat/add-id
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Generate an ID for an event
The `add_id` processor generates a unique ID for an event.
```yaml
processors:
  - add_id: ~
```

The following settings are supported:
<definitions>
  <definition term="target_field">
    (Optional) Field where the generated ID will be stored. Default is `@metadata._id`.
  </definition>
  <definition term="type">
    (Optional) Type of ID to generate. Currently only `elasticsearch` is supported and is the default. The `elasticsearch` type generates IDs using the same algorithm that Elasticsearch uses for auto-generating document IDs.
  </definition>
</definitions>