﻿---
title: Add fields
description: The add_fields processor adds additional fields to the event.  Fields can be scalar values, arrays, dictionaries, or any nested combination of these...
url: https://www.elastic.co/docs/reference/beats/auditbeat/add-fields
products:
  - Auditbeat
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Add fields
The `add_fields` processor adds additional fields to the event.  Fields can be scalar values, arrays, dictionaries, or any nested combination of these. The `add_fields` processor will overwrite the target field if it already exists. By default the fields that you specify will be grouped under the `fields` sub-dictionary in the event. To group the fields under a different sub-dictionary, use the `target` setting. To store the fields as top-level fields, set `target: ''`.
<definitions>
  <definition term="target">
    (Optional) Sub-dictionary to put all fields into. Defaults to `fields`. Setting this to `@metadata` will add values to the event metadata instead of fields.
  </definition>
  <definition term="fields">
    Fields to be added.
  </definition>
</definitions>

For example, this configuration:
```yaml
processors:
  - add_fields:
      target: project
      fields:
        name: myproject
        id: '574734885120952459'
```

Adds these fields to any event:
```json
{
  "project": {
    "name": "myproject",
    "id": "574734885120952459"
  }
}
```

This configuration will alter the event metadata:
```yaml
processors:
  - add_fields:
      target: '@metadata'
      fields:
        op_type: "index"
```

When the event is ingested (e.g. by Elastisearch) the document will have `op_type: "index"` set as a metadata field.