﻿---
title: Beats
description: Beats are open source data shippers that you install as agents on your servers to send operational data to Elasticsearch. New to Beats? Check out the...
url: https://www.elastic.co/docs/reference/beats
products:
  - Beats
---

# Beats
Beats are open source data shippers that you install as agents on your servers to send operational data to [Elasticsearch](https://www.elastic.co/products/elasticsearch).
New to Beats? Check out the [Beats overview](https://www.elastic.co/beats) to see what Beats can do for you.
Elastic provides Beats for capturing:
<definitions>
  <definition term="Audit data">
    [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat)
  </definition>
  <definition term="Log files and journals">
    [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat)
  </definition>
  <definition term="Availability">
    [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat)
  </definition>
  <definition term="Metrics">
    [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat)
  </definition>
  <definition term="Network traffic">
    [Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat)
  </definition>
  <definition term="Windows event logs">
    [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat)
  </definition>
</definitions>

Beats can send data directly to Elasticsearch or through [Logstash](https://www.elastic.co/products/logstash), where you can further process and enhance the data, before visualizing it in [Kibana](https://www.elastic.co/products/logstash).
![Beats Platform](https://www.elastic.co/docs/reference/beats/libbeat/images/beats-platform.png)
Want to get up and running quickly with infrastructure metrics monitoring and centralized log analytics? Try out the Metrics app and the Logs app in Kibana. For more details, check out [Analyze metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) and [Monitor logs](https://www.elastic.co/docs/solutions/observability/logs/explore-logs).

## Need to capture other kinds of data?

If you have a specific use case to solve, we encourage you to create a [community Beat](https://www.elastic.co/docs/reference/beats/libbeat/community-beats). We’ve created an infrastructure to simplify the process. The *libbeat* library, written entirely in Go, offers the API that all Beats use to ship data to Elasticsearch, configure the input options, implement logging, and more. To learn how to create a new Beat, see [Contribute to Beats](https://www.elastic.co/docs/extend/beats).