﻿---
title: APM settings
description: How you configure the APM Server depends on your deployment method. APM Server binary users need to edit the apm-server.yml configuration file. The location...
url: https://www.elastic.co/docs/reference/apm/observability/apm-settings
products:
  - Elastic Observability
---

# APM settings
How you configure the APM Server depends on your deployment method.
- **APM Server binary** users need to edit the `apm-server.yml` configuration file. The location of the file varies by platform. To locate the file, see [Installation layout](https://www.elastic.co/docs/solutions/observability/apm/apm-server/installation-layout).
- **Fleet-managed** users configure the APM Server directly in Kibana. Each configuration page describes the specific location.
- **Elastic cloud** users should see [Add APM user settings](https://www.elastic.co/docs/reference/apm/cloud/apm-settings) for information on how to configure Elastic APM.

The following topics describe how to configure APM Server:
- [General configuration options](https://www.elastic.co/docs/solutions/observability/apm/apm-server/general-configuration-options)
- [Anonymous authentication](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-anonymous-authentication)
- [APM agent authorization](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-authorization)
- [APM agent central configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration)
- [Instrumentation](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-apm-instrumentation)
- [Kibana endpoint](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-kibana-endpoint)
- [Logging](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-logging)
- [Output](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-output)
- [Project paths](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-project-paths)
- [Real User Monitoring (RUM)](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-real-user-monitoring-rum)
- [SSL/TLS settings](https://www.elastic.co/docs/solutions/observability/apm/apm-server/ssl-tls-settings)
- [Tail-based sampling](https://www.elastic.co/docs/solutions/observability/apm/apm-server/tail-based-sampling)
- [Use environment variables in the configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-server/use-environment-variables-in-configuration)