﻿---
title: Install the webhook with Helm
description: Install the webhook with Helm. Pass in your custom.yaml configuration file created in the previous step with the --values flag. 
url: https://www.elastic.co/docs/reference/apm/k8s-attacher/apm-webhook-install-helm
products:
  - APM
  - APM Attacher for Kubernetes
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Install the webhook with Helm
Install the webhook with Helm. Pass in your `custom.yaml` configuration file created in the previous step with the `--values` flag.
```bash
helm install [name] \ 
  elastic/apm-attacher \
  --namespace=elastic-apm \ 
  --create-namespace \
  --values custom.yaml
```

<note>
  `helm upgrade ...` can be used to upgrade an existing installation, eg if you have a new version of the `custom.yaml` configuration file.
</note>