﻿---
title: Configure the webhook with a Helm values file
description: The APM Attacher’s webhook can be installed from a Helm chart. You can provide a custom webhook configuration using a Helm values file. Elastic provides...
url: https://www.elastic.co/docs/reference/apm/k8s-attacher/apm-webhook-configure-helm
products:
  - APM
  - APM Attacher for Kubernetes
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Configure the webhook with a Helm values file
The APM Attacher’s webhook can be installed from a Helm chart. You can provide a custom webhook configuration using a Helm values file. Elastic provides a [`custom.yaml`](https://github.com/elastic/apm-k8s-attacher/blob/main/custom.yaml) file as a starting point.
This sample `custom.yaml` file instruments a pod with the **Elastic APM Java agent**:
```yaml
apm:
  secret_token: SuP3RT0K3N 
  namespaces: 
    - default
    - my-name-space-01
    - my-name-space-02
webhookConfig:
  agents:
    java: 
      environment:
        ELASTIC_APM_SERVER_URL: "<YOUR_APM_SERVER_URL>:<PORT>" 
        ELASTIC_APM_ENVIRONMENT: "prod"
        ELASTIC_APM_LOG_LEVEL: "info"
```

This sample `custom.yaml` file instruments a pod with the **Elastic APM Node.js agent**:
```yaml
apm:
  secret_token: SuP3RT0K3N 
  namespaces: 
    - default
    - my-name-space-01
    - my-name-space-02
webhookConfig:
  agents:
    nodejs: 
      environment:
        ELASTIC_APM_SERVER_URL: "<YOUR_APM_SERVER_URL>:<PORT>" 
        ELASTIC_APM_ENVIRONMENT: "prod"
        ELASTIC_APM_LOG_LEVEL: "info"
```

<tip>
  The examples above assume that you want to use the latest version of the Elastic APM agent. Advanced users may want to pin a version of the agent or provide a custom build. To do this, set your own `image`, `artifact`, and `environment.*OPTIONS` fields. Copy the formatting from [`values.yaml`](https://github.com/elastic/apm-k8s-attacher/blob/main/charts/apm-attacher/values.yaml).
</tip>

<note>
  Expiring and rotating API keys will need to update the `custom.yaml`, upgrade the helm install with the new `custom.yaml`, and cycle running pods in a similar way to other deployment definition changes.
</note>