﻿---
title: Add a pod template annotation to each pod you want to auto-instrument
description: To auto-instrument a deployment, update its spec.template.metadata.annotations to include the co.elastic.apm/attach key. The webhook matches the value...
url: https://www.elastic.co/docs/reference/apm/k8s-attacher/apm-webhook-add-pod-annotation
products:
  - APM
  - APM Attacher for Kubernetes
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Add a pod template annotation to each pod you want to auto-instrument
To auto-instrument a deployment, update its `spec.template.metadata.annotations` to include the `co.elastic.apm/attach` key. The webhook matches the value of this key to the `webhookConfig.agents` value defined in your Helm values file.
For example, if your Webhook values file includes the following:
```yaml
...
webhookConfig:
  agents:
    java:
...
```

Then your `co.elastic.apm/attach` value should be `java`:
```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  # ...
spec:
  replicas: 1
  template:
    metadata:
      annotations:
        co.elastic.apm/attach: java 
      labels:
        # ...
    spec:
      #...
```

The `spec.template.metadata.annotations` value allows you to set custom environment variables and images per deployment. For example, your Helm values file might configure a number of deployments: `java-dev` might have a different APM environment from `java-prod`, and `backend2` use a different APM agent than other deployments.
```yaml
agents:
  java-dev:
    image: docker.elastic.co/observability/apm-agent-java:latest
    artifact: "/usr/agent/elastic-apm-agent.jar"
    environment:
      ELASTIC_APM_SERVER_URL: "http://192.168.1.10:8200"
      ELASTIC_APM_ENVIRONMENT: "dev"
      ELASTIC_APM_LOG_LEVEL: "debug"
      ELASTIC_APM_PROFILING_INFERRED_SPANS_ENABLED: "true"
      JAVA_TOOL_OPTIONS: "-javaagent:/elastic/apm/agent/elastic-apm-agent.jar"
  java-prod:
    image: docker.elastic.co/observability/apm-agent-java:1.44.0 
    artifact: "/usr/agent/elastic-apm-agent.jar"
    environment:
      ELASTIC_APM_SERVER_URL: "http://192.168.1.11:8200"
      ELASTIC_APM_ENVIRONMENT: "prod"
      ELASTIC_APM_LOG_LEVEL: "info"
      ELASTIC_APM_PROFILING_INFERRED_SPANS_ENABLED: "true"
      JAVA_TOOL_OPTIONS: "-javaagent:/elastic/apm/agent/elastic-apm-agent.jar"
  backend2:
    image: docker.elastic.co/observability/apm-agent-nodejs:latest
    artifact: "/opt/nodejs/node_modules/elastic-apm-node"
    environment:
      NODE_OPTIONS: "-r /elastic/apm/agent/elastic-apm-node/start"
      ELASTIC_APM_SERVER_URL: "http://192.168.1.11:8200"
      ELASTIC_APM_SERVICE_NAME: "petclinic"
      ELASTIC_APM_LOG_LEVEL: "info"
```

<important>
  The only `webhookConfig.agents` values defined in [`values.yaml`](https://github.com/elastic/apm-k8s-attacher/blob/main/charts/apm-attacher/values.yaml) are `java` and `nodejs`. When using other values, you must explicitly specify `image`, `artifact`, and `*OPTIONS` values.
</important>

<important>
  The environment variables defined in the webhook and here take precedence - overwrite - the values defined in the Kubernetes deployments. For example if your image uses JAVA_TOOL_OPTIONS, the value your image sets will be ignored in favour of the value set here or in the [`values.yaml`](https://github.com/elastic/apm-k8s-attacher/blob/main/charts/apm-attacher/values.yaml).
</important>