﻿---
title: APM Attacher for Kubernetes
description: The APM attacher for Kubernetes simplifies the instrumentation and configuration of your application pods. The attacher includes a webhook receiver that...
url: https://www.elastic.co/docs/reference/apm/k8s-attacher
products:
  - APM
  - APM Attacher for Kubernetes
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# APM Attacher for Kubernetes
<important>
  The APM Attacher for Kubernetes is in maintenance mode. Only prioritized bug fixes will be applied. The OpenTelemetry Operator fully replaces the Attacher and is actively developed by the community.To migrate, see [Migrate from the Elastic APM Attacher for Kubernetes](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/instrumenting-applications#migrate-from-the-elastic-apm-attacher-for-kubernetes).
</important>

The APM attacher for Kubernetes simplifies the instrumentation and configuration of your application pods.
The attacher includes a [webhook receiver](#apm-webhook) that modifies pods so they are automatically instrumented by an Elastic APM agent, and a [Helm chart](#apm-helm-chart) that manages its lifecycle within Kubernetes.
Learn more below, or skip ahead to [*Instrument and configure pods*](https://www.elastic.co/docs/reference/apm/k8s-attacher/apm-get-started-webhook).

## Webhook

The webhook receiver modifies pods so they are automatically instrumented by an Elastic APM agent. Supported agents include:
- [Java agent](https://www.elastic.co/docs/reference/apm/agents/java)
- [Node.js agent](https://www.elastic.co/docs/reference/apm/agents/nodejs)
- <applies-to>: Preview</applies-to> [.NET agent](https://www.elastic.co/docs/reference/apm/agents/dotnet)

The webhook receiver is invoked on pod creation. After receiving the object definition from the Kubernetes API server, it looks through the pod spec for a specific, user-supplied annotation. If found, the pod spec is mutated according to the webhook receiver’s configuration. This mutated object is then returned to the Kubernetes API server which uses it as the source of truth for the object.

## Mutation

The mutation that occurs is defined below:
1. Add an init container image that has the agent binary.
2. Add a shared volume that is mounted into both the init container image and all container images contained in the original incoming object.
3. Copy the agent binary from the init container image into the shared volume, making it available to the other container images.
4. Update the environment variables in the container images to configure auto-instrumentation with the copied agent binary

<tip>
  To learn more about mutating webhooks, see the [Kubernetes Admission controller documentation](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/).
</tip>


## Helm chart

The Helm chart manages the configuration of all associated manifest files for the webhook receiver, including generating certificates for securing communication between the Kubernetes API server and the webhook receiver.
<tip>
  To learn more about Helm charts, see the [Helm documentation](https://helm.sh/docs/).
</tip>