﻿---
title: APM settings for Elastic Cloud
description: Change how Elastic APM runs by providing your own user settings. Starting in Elastic Stack version 8.0, how you change APM settings and the settings that...
url: https://www.elastic.co/docs/reference/apm/cloud/apm-settings
products:
  - Elastic Cloud Hosted
---

# APM settings for Elastic Cloud
Change how Elastic APM runs by providing your own user settings. Starting in Elastic Stack version 8.0, how you change APM settings and the settings that are available to you depend on how you spin up Elastic APM. There are two modes:
<definitions>
  <definition term="Fleet-managed APM integration">
    New deployments created in Elastic Stack version 8.0 and later will be managed by Fleet.
    Check [APM configuration reference](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for information on how to configure Elastic APM in this mode.
  </definition>
  <definition term="Standalone APM Server (legacy)">
    Deployments created prior to Elastic Stack version 8.0 are in legacy mode. Upgrading to or past Elastic Stack 8.0 will not remove you from legacy mode.
    Check [Edit standalone APM settings (legacy)](#ec-edit-apm-standalone-settings) and [Supported standalone APM settings (legacy)](#ec-apm-settings) for information on how to configure Elastic APM in this mode.
  </definition>
</definitions>

To learn more about the differences between these modes, or to switch from Standalone APM Server (legacy) mode to Fleet-managed, check [Switch to the Elastic APM integration](https://www.elastic.co/docs/solutions/observability/apm/switch-to-elastic-apm-integration).

## Edit standalone APM settings (legacy)

User settings are appended to the `apm-server.yml` configuration file for your instance and provide custom configuration options.
To add user settings:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Find your deployment on the home page or on the **Hosted deployments** page, then select **Manage** to access its settings menus.
   On the **Hosted deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
3. From your deployment menu, go to the **Edit** page.
4. In the **APM** section, select **Edit user settings**. (For existing deployments with user settings, you may have to expand the **Edit apm-server.yml** caret instead.)
5. Update the user settings.
6. Select **Save changes**.

<note>
  If a setting is not supported by Elastic Cloud Hosted, you will get an error message when you try to save.
</note>


## Supported standalone APM settings (legacy)

Elastic Cloud Hosted generally supports the settings listed in [APM documentation](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) under "APM Server binary" when running APM in standalone mode (legacy). For versions before 9, refer to [older documentation](https://www.elastic.co/guide/en/observability/8.18/apm-configuring-howto-apm-server.html).
<note>
  Some settings are intentionally restricted to maintain system stability.
</note>

<note>
  To change logging settings you must first [enable deployment logging](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring).
</note>