﻿---
title: Configuration options
description: The recommended way of configuring the Elastic APM AWS Lambda extension and the APM agents on AWS Lambda is through the Lambda function’s environment...
url: https://www.elastic.co/docs/reference/apm/aws-lambda/aws-lambda-config-options
products:
  - APM
  - APM AWS Lambda extension
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Configuration options
The recommended way of configuring the Elastic APM AWS Lambda extension and the APM agents on AWS Lambda is through the Lambda function’s environment variables.
The configuration options for the APM agents are documented in the corresponding language agents:
- [Configuration options - Node.js APM agent](https://www.elastic.co/docs/reference/apm/agents/nodejs/configuration)
- [Configuration options - Python APM agent](https://www.elastic.co/docs/reference/apm/agents/python/configuration)
- [Configuration options - Java APM agent](https://www.elastic.co/docs/reference/apm/agents/java/configuration)

<note>
  Some APM agent configuration options don’t make sense when the APM agent is running in a Lambda environment. For example, instead of using the Python APM agent configuration variable, `verify_server_cert`, you must use the `ELASTIC_APM_LAMBDA_VERIFY_SERVER_CERT` variable described below.
</note>

<note>
  APM Central configuration is not supported when using the Elastic APM AWS Lambda extension
</note>


## Relevant configuration options

A list of relevant configuration options for the Elastic APM AWS Lambda extension is below.

### `ELASTIC_APM_LAMBDA_APM_SERVER`

This required config option controls where the Elastic APM AWS Lambda extension will ship data. This should be the URL of the final APM Server destination for your telemetry.

### `ELASTIC_APM_LAMBDA_AGENT_DATA_BUFFER_SIZE`

The size of the buffer that stores APM agent data to be forwarded to the APM server. The *default* is `100`.

### `ELASTIC_APM_SECRET_TOKEN` or `ELASTIC_APM_API_KEY`

One of these (or, alternatively, the corresponding settings for the AWS Secrets Manager IDs) needs to be set as the authentication method that the Elastic APM AWS Lambda extension uses when sending data to the URL configured via `ELASTIC_APM_LAMBDA_APM_SERVER`. Alternatively, you can store your APM Server credentials [using the AWS Secrets Manager](https://www.elastic.co/docs/reference/apm/aws-lambda/aws-lambda-secrets-manager) and use the [`ELASTIC_APM_SECRETS_MANAGER_SECRET_TOKEN_ID` or `ELASTIC_APM_SECRETS_MANAGER_API_KEY_ID`](#aws-lambda-config-secrets-manager-options) config options, instead. Sending data to the APM Server if none of these options is set is possible, but your APM agent must be allowed to send data to your APM server in [anonymous mode](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-anonymous-authentication).

### `ELASTIC_APM_SECRETS_MANAGER_SECRET_TOKEN_ID` or `ELASTIC_APM_SECRETS_MANAGER_API_KEY_ID`

Instead of specifying the [`ELASTIC_APM_SECRET_TOKEN` or `ELASTIC_APM_API_KEY`](#aws-lambda-config-authentication-keys) as plain text in your Lambda environment variables, you can [use the AWS Secrets Manager](https://www.elastic.co/docs/reference/apm/aws-lambda/aws-lambda-secrets-manager) to securely store your APM authetication keys. The `ELASTIC_APM_SECRETS_MANAGER_API_KEY_ID` or `ELASTIC_APM_SECRETS_MANAGER_SECRET_TOKEN_ID` config options allow you to specify the Secrets Manager’s secret id of the stored APM API key or APM secret token, respectively, to be used by the Elastic APM AWS Lambda extension for authentication.
`ELASTIC_APM_SECRETS_MANAGER_SECRET_TOKEN_ID` takes precedence over [`ELASTIC_APM_SECRET_TOKEN`](#aws-lambda-config-authentication-keys), and `ELASTIC_APM_SECRETS_MANAGER_API_KEY_ID` over [`ELASTIC_APM_API_KEY`](#aws-lambda-config-authentication-keys), respectively.

### `ELASTIC_APM_SERVICE_NAME`

The configured name of your application or service.  The APM agent will use this value when reporting data to the APM Server. If unset, the APM agent will automatically set the value based on the Lambda function name. Use this config option if you want to group multiple Lambda functions under a single service entity in APM.

### `ELASTIC_APM_DATA_RECEIVER_TIMEOUT`

<applies-to>
  - : Generally available since 1.2
</applies-to>

Replaces `ELASTIC_APM_DATA_RECEIVER_TIMEOUT_SECONDS`.
The Elastic APM AWS Lambda extension's timeout value, for receiving data from the APM agent. The *default* is `15s`.

### `ELASTIC_APM_DATA_RECEIVER_SERVER_PORT`

The port on which the Elastic APM AWS Lambda extension listens to receive data from the APM agent. The *default* is `8200`.

### `ELASTIC_APM_DATA_FORWARDER_TIMEOUT`

<applies-to>
  - : Generally available since 1.2
</applies-to>

Replaces `ELASTIC_APM_DATA_FORWARDER_TIMEOUT_SECONDS`.
The timeout value, for the Elastic APM AWS Lambda extension's HTTP client sending data to the APM Server. The *default* is `3s`. If the extension's attempt to send APM data during this time interval is not successful, the extension queues back the data. Further attempts at sending the data are governed by an exponential backoff algorithm: data will be sent after a increasingly large grace period of 0, then circa 1, 4, 9, 16, 25 and 36 seconds, provided that the Lambda function execution is ongoing.

### `ELASTIC_APM_SEND_STRATEGY`

Whether to synchronously flush APM agent data from the Elastic APM AWS Lambda extension to the APM Server at the end of the function invocation. The two accepted values are `background` and `syncflush`. The *default* is `syncflush`.
- The `background` strategy indicates that the Elastic APM AWS Lambda extension will not flush when it receives a signal that the function invocation has completed. It will instead send any remaining buffered data on the next function invocation. The result is that, if the function is not subsequently invoked for that Lambda environment, the buffered data will be lost. However, for lambda functions that have a steadily frequent load pattern the extension could delay sending the data to the APM Server to the next lambda request and do the sending in parallel to the processing of that next request. This potentially would improve both the lambda function response time and its throughput.
- The other value, `syncflush` will synchronously flush all remaining buffered APM agent data to the APM Server when the extension receives a signal that the function invocation has completed. This strategy blocks the lambda function from receiving the next request until the extension has flushed all the data. This has a negative effect on the throughput of the function, though it ensures that all APM data is sent to the APM server.


### `ELASTIC_APM_LOG_LEVEL`

The logging level to be used by both the APM Agent and the Elastic APM AWS Lambda extension. Supported values are `trace`, `debug`, `info`, `warning`, `error`, `critical` and `off`.

### `ELASTIC_APM_LAMBDA_CAPTURE_LOGS`

<applies-to>
  - : Preview
</applies-to>

Starting in Elastic Stack version 8.5.0, the Elastic APM lambda extension supports the collection of log events by default. Log events can be viewed in Kibana in the APM UI. Disable log collection by setting this to `false`.

### `ELASTIC_APM_LAMBDA_VERIFY_SERVER_CERT`

<applies-to>
  - : Generally available since 1.3
</applies-to>

Whether to enable Elastic APM AWS Lambda extension to verify APM Server's certificate chain and host name.

### `ELASTIC_APM_LAMBDA_SERVER_CA_CERT_PEM`

<applies-to>
  - : Generally available since 1.3
</applies-to>

The certificate passed as environment variable. To be used to verify APM Server's certificate chain if verify server certificate is enabled.

### `ELASTIC_APM_SERVER_CA_CERT_FILE`

<applies-to>
  - : Generally available since 1.3
</applies-to>

The certificate passed as a file name available to the extension. To be used to verify APM Server's certificate chain if verify server certificate is enabled.

### `ELASTIC_APM_SERVER_CA_CERT_ACM_ID`

<applies-to>
  - : Generally available since 1.3
</applies-to>

The ARN for Amazon-issued certificate. To be used to verify APM Server's certificate chain if verify server certificate is enabled.
<note>
  You may see errors similar to the following in Elastic Stack versions less than 8.5:
  ```text
  client error: response status code: 400
  message: log: did not recognize object type
  ```
  Users on older versions should disable log collection by setting `ELASTIC_APM_LAMBDA_CAPTURE_LOGS` to `false`.
</note>


## Deprecated options


### `ELASTIC_APM_DATA_RECEIVER_TIMEOUT_SECONDS`

<applies-to>
  - : Deprecated since 1.2
</applies-to>

Use [`ELASTIC_APM_DATA_RECEIVER_TIMEOUT`](#aws-lambda-config-data-receiver-timeout) instead.
The Elastic APM AWS Lambda extension's timeout value, in seconds, for receiving data from the APM agent. The *default* is `15`.

### `ELASTIC_APM_DATA_FORWARDER_TIMEOUT_SECONDS`

<applies-to>
  - : Deprecated since 1.2
</applies-to>

Use [`ELASTIC_APM_DATA_FORWARDER_TIMEOUT`](#aws-lambda-config-data-forwarder-timeout) instead.
The timeout value, in seconds, for the Elastic APM AWS Lambda extension's HTTP client sending data to the APM Server. The *default* is `3`. If the extension’s attempt to send APM data during this time interval is not successful, the extension queues back the data. Further attempts at sending the data are governed by an exponential backoff algorithm: data will be sent after a increasingly large grace period of 0, then circa 1, 4, 9, 16, 25 and 36 seconds, provided that the Lambda function execution is ongoing.