﻿---
title: Upgrading
description: Upgrades between minor versions of the agent, like from 3.1 to 3.2 are always backwards compatible. Upgrades that involve a major version bump often come...
url: https://www.elastic.co/docs/reference/apm/agents/rum-js/upgrading
products:
  - APM Agent
  - APM RUM JavaScript Agent
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Upgrading
Upgrades between minor versions of the agent, like from 3.1 to 3.2 are always backwards compatible. Upgrades that involve a major version bump often come with some backwards incompatible changes.
Before upgrading the agent, be sure to review the:
- [Agent release notes](https://www.elastic.co/docs/release-notes/apm/agents/rum-js)
- [Agent and Server compatibility chart](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility)

The following upgrade guides are also available:
- [Upgrade to version 5.x](https://www.elastic.co/docs/release-notes/apm/agents/rum-js/breaking-changes) - Follow this guide to upgrade from version `4.x` to version `5.x` of the Elastic APM RUM JS Agent.


## End of life dates

We love all our products, but sometimes we must say goodbye to a release so that we can continue moving forward on future development and innovation. Our [End of life policy](https://www.elastic.co/support/eol) defines how long a given release is considered supported, as well as how long a release is considered still in active development or maintenance. The table below is a simplified description of this policy.

| Agent version | EOL Date   | Maintained until |
|---------------|------------|------------------|
| 4.8.x         | 2021-08-13 | 4.9.0            |
| 4.7.x         | 2021-07-15 | 4.8.0            |
| 4.6.x         | 2021-05-19 | 4.7.0            |
| 4.5.x         | 2021-03-30 | 4.6.0            |
| 4.4.x         | 2021-02-05 | 4.5.0            |
| 4.3.x         | 2021-01-11 | 4.4.0            |
| 4.2.x         | 2021-01-08 | 4.3.0            |
| 4.1.x         | 2020-12-12 | 4.2.0            |
| 4.0.x         | 2020-09-11 | 4.1.0            |
| 3.0.x         | 2020-07-29 | 5.0.0            |
| 2.3.x         | 2020-06-18 | 4.0.0            |
| 2.2.x         | 2020-06-05 | 2.3.0            |
| 2.1.x         | 2020-06-03 | 2.2.0            |
| 2.0.x         | 2020-05-14 | 2.1.0            |
| 1.0.x         | 2020-02-23 | 3.0.0            |