﻿---
title: Getting started with Rails
description: Add the gem to your Gemfile: Create a file config/elastic_apm.yml: Or if you prefer environment variables, skip the file and set ELASTIC_APM_SERVER_URL...
url: https://www.elastic.co/docs/reference/apm/agents/ruby/getting-started-rails
products:
  - APM Agent
  - APM Ruby Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Ruby: Generally available
---

# Getting started with Rails
## Setup

Add the gem to your `Gemfile`:
```ruby
gem 'elastic-apm'
```

Create a file `config/elastic_apm.yml`:
```yaml
server_url: http://localhost:8200
secret_token: ''
```

Or if you prefer environment variables, skip the file and set `ELASTIC_APM_SERVER_URL` and `ELASTIC_APM_SECRET_TOKEN` in your local or server environment.
This automatically sets up error logging and performance tracking but of course there are knobs to turn if you’d like to. See [*Configuration*](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration).