﻿---
title: Custom instrumentation
description: When installed and properly configured, ElasticAPM will automatically wrap your app’s request/responses in transactions and report its errors. It also...
url: https://www.elastic.co/docs/reference/apm/agents/ruby/custom-instrumentation
products:
  - APM Agent
  - APM Ruby Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Ruby: Generally available
---

# Custom instrumentation
When installed and properly configured, ElasticAPM will automatically wrap your app’s request/responses in transactions and report its errors. It also wraps each background job if you use Sidekiq or DelayedJob.
But it is also possible to create your own transactions as well as provide spans for any automatic or custom transaction.
See [`ElasticAPM.start_transaction`](/docs/reference/apm/agents/ruby/api-reference#api-agent-start_transaction) and [`ElasticAPM.start_span`](/docs/reference/apm/agents/ruby/api-reference#api-agent-start_span).

## Helpers

ElasticAPM includes some nifty helpers if you just want to instrument a regular method.
```ruby
class Thing
  include ElasticAPM::SpanHelpers

  def do_the_work
    # ...
  end
  span_method :do_hard_work

  def self.do_all_the_work
    # ...
  end
  span_class_method :do_hard_work, 'Custom name', 'custom.work_thing'
end
```


## Custom span example

If you are already inside a Transaction (most likely) and you want to instrument some work inside it, add a custom span:
```ruby
class ThingsController < ApplicationController
  def index
    @result_of_work = ElasticAPM.with_span "Heavy work" do
      do_the_heavy_work
    end
  end
end
```


## Custom transaction example

If you are **not** inside a Transaction already (eg. outside of your common web application) start and manage your own transactions like so:
```ruby
class Something
  def do_work
    transaction = ElasticAPM.start_transaction 'Something#do_work'

    begin
      Sequel[:users]
    rescue Exception => e
      ElasticAPM.report(e)
      raise
    ensure
      ElasticAPM.end_transaction('result')
    end
  end
end
```

**Note:** If the agent isn’t started beforehand this will do nothing. See [ElasticAPM.start](/docs/reference/apm/agents/ruby/api-reference#api-agent-start).