﻿---
title: Adding additional context
description: You can add your own custom, nested JSON-compatible data to the current transaction using ElasticAPM.set_custom_context(hash) eg.: Labels are special...
url: https://www.elastic.co/docs/reference/apm/agents/ruby/context
products:
  - APM Agent
  - APM Ruby Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Ruby: Generally available
---

# Adding additional context
## Adding custom context

You can add your own custom, nested JSON-compatible data to the current transaction using `ElasticAPM.set_custom_context(hash)` eg.:
```ruby
class ThingsController < ApplicationController
  before_action do
    ElasticAPM.set_custom_context(company: current_user.company)
  end

  # ...
end
```


## Adding labels

Labels are special in that they are indexed in your Elasticsearch database and therefore queryable.
```ruby
ElasticAPM.set_label(:company_name, 'Acme, Inc.')
```

Note that `.`, `*` and `"` in keys are converted to `_`.

## Providing info about the user

You can provide ElasticAPM with info about the current user.
```ruby
class ApplicationController < ActionController::Base
  before_action do
    current_user && ElasticAPM.set_user(current_user)
  end
end
```