﻿---
title: APM Ruby agent
description: The Elastic APM Ruby Agent sends performance metrics and error logs to the APM Server. It has built-in support for Ruby on Rails and other Rack-compatible...
url: https://www.elastic.co/docs/reference/apm/agents/ruby
products:
  - APM Agent
  - APM Ruby Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Ruby: Generally available
---

# APM Ruby agent
The Elastic APM Ruby Agent sends performance metrics and error logs to the APM Server. It has built-in support for [Ruby on Rails](https://www.elastic.co/docs/reference/apm/agents/ruby/getting-started-rails) and other [Rack-compatible](https://www.elastic.co/docs/reference/apm/agents/ruby/getting-started-rack) applications. It also offers an API which allows you to instrument any application.

## How does the Agent work?

The agent auto-instruments [supported technologies](https://www.elastic.co/docs/reference/apm/agents/ruby/supported-technologies) and records interesting events, like HTTP requests and database queries. To do this, it uses relevant public APIs when they are provided by the libraries. Otherwise, it carefully wraps the necessary internal methods. This means that for the supported technologies, there are no code changes required.
The Agent automatically keeps track of queries to your data stores to measure their duration and metadata (like the DB statement), as well as HTTP related information (like the URL, parameters, and headers).
These events, called Transactions and Spans, are sent to the APM Server. The APM Server converts them to a format suitable for Elasticsearch, and sends them to an Elasticsearch cluster. You can then use the APM app in Kibana to gain insight into latency issues and error culprits within your application.

## Additional Components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started), and [Kibana](https://www.elastic.co/docs/get-started/the-stack). The [APM Guide](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM Ruby agent, refer to [Troubleshoot APM Ruby Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-ruby/apm-ruby-agent).