﻿---
title: Upgrading to version 4 of the agent
description: 4.0 of the Elastic APM Python Agent comes with several backwards incompatible changes. This version of the agent is only compatible with APM Server 6.5+...
url: https://www.elastic.co/docs/reference/apm/agents/python/upgrading-4-x
products:
  - APM Agent
  - APM Python Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Python: Generally available
---

# Upgrading to version 4 of the agent
4.0 of the Elastic APM Python Agent comes with several backwards incompatible changes.

## APM Server 6.5 required

This version of the agent is **only compatible with APM Server 6.5+**. To upgrade, we recommend to first upgrade APM Server, and then the agent. APM Server 6.5+ is backwards compatible with versions 2.x and 3.x of the agent.

## Configuration options

Several configuration options have been removed, or renamed
- `flush_interval` has been removed
- the `flush_interval` and `max_queue_size` settings have been removed.
- new settings introduced: `api_request_time` and `api_request_size`.
- Some settings now require a unit for duration or size. See [size format](/docs/reference/apm/agents/python/configuration#config-format-size) and [duration format](/docs/reference/apm/agents/python/configuration#config-format-duration).


## Processors

The method to write processors for sanitizing events has been changed. It will now be called for every type of event (transactions, spans and errors), unless the event types are limited using a decorator. See [Sanitizing data](https://www.elastic.co/docs/reference/apm/agents/python/sanitizing-data) for more information.