﻿---
title: Monitoring AWS Lambda Python Functions
description: The Python APM Agent can be used with AWS Lambda to monitor the execution of your AWS Lambda functions. You need an APM Server to send APM data to. Follow...
url: https://www.elastic.co/docs/reference/apm/agents/python/lambda-support
products:
  - APM Agent
  - APM Python Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Python: Generally available
---

# Monitoring AWS Lambda Python Functions
The Python APM Agent can be used with AWS Lambda to monitor the execution of your AWS Lambda functions.
<note>
  The Centralized Agent Configuration on the Elasticsearch APM currently does NOT support AWS Lambda.
</note>


## Prerequisites

You need an APM Server to send APM data to. Follow the [APM Quick start](https://www.elastic.co/docs/solutions/observability/apm/apm-server/fleet-managed) if you have not set one up yet. For the best-possible performance, we recommend setting up APM on Elastic Cloud in the same AWS region as your AWS Lambda functions.

## Step 1: Add the APM Layers to your Lambda function

Both the [Elastic APM AWS Lambda extension](https://www.elastic.co/docs/reference/apm/aws-lambda) and the Python APM Agent are added to your Lambda function as [AWS Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html). Therefore, you need to add the corresponding Layer ARNs (identifiers) to your Lambda function.
<tab-set>
  <tab-item title="AWS Web Console">
    To add the layers to your Lambda function through the AWS Management Console:
    1. Navigate to your function in the AWS Management Console
    2. Scroll to the Layers section and click the *Add a layer* button ![image of layer configuration section in AWS Console](https://www.elastic.co/docs/reference/apm/agents/python/images/config-layer.png)
    3. Choose the *Specify an ARN* radio button
    4. Copy and paste the following ARNs of the Elastic APM AWS Lambda extension layer and the APM agent layer in the *Specify an ARN* text input:
       - APM Extension layer:
      ```bash
      arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-extension-ver-1-6-0-{ARCHITECTURE}:1 
      ```
    - APM agent layer:
      ```bash
      arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-python-ver-6-25-0:1 
      ```
       ![image of choosing a layer in AWS Console](https://www.elastic.co/docs/reference/apm/agents/python/images/choose-a-layer.png)
    5. Click the *Add* button
  </tab-item>

  <tab-item title="AWS CLI">
    To add the Layer ARNs of the Elastic APM AWS Lambda extension and the APM agent through the AWS command line interface execute the following command:
    ```bash
    aws lambda update-function-configuration --function-name yourLambdaFunctionName \
    --layers arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-extension-ver-1-6-0-{ARCHITECTURE}:1 \ 
    arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-python-ver-6-25-0:1 
    ```
  </tab-item>

  <tab-item title="SAM">
    In your SAM `template.yml` file add the Layer ARNs of the Elastic APM AWS Lambda extension and the APM agent as follows:
    ```yaml
    ...
    Resources:
      yourLambdaFunction:
        Type: AWS::Serverless::Function
        Properties:
          ...
          Layers:
              - arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-extension-ver-1-6-0-{ARCHITECTURE}:1 
              - arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-python-ver-6-25-0:1 
    ...
    ```
  </tab-item>

  <tab-item title="Serverless">
    In your `serverless.yml` file add the Layer ARNs of the Elastic APM AWS Lambda extension and the APM agent to your function as follows:
    ```yaml
    ...
    functions:
      yourLambdaFunction:
        handler: ...
        layers:
          - arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-extension-ver-1-6-0-{ARCHITECTURE}:1 
          - arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-python-ver-6-25-0:1 
    ...
    ```
  </tab-item>

  <tab-item title="Terraform">
    To add theElastic APM AWS Lambda extension and the APM agent to your function add the ARNs to the `layers` property in your Terraform file:
    ```yaml
    ...
    resource "aws_lambda_function" "your_lambda_function" {
      ...
      layers = ["arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-extension-ver-1-6-0-{ARCHITECTURE}:1", "arn:aws:lambda:{AWS_REGION}:267093732750:layer:elastic-apm-python-ver-6-25-0:1"] 
    }
    ...
    ```
  </tab-item>

  <tab-item title="Container Image">
    To add the Elastic APM AWS Lambda extension and the APM agent to your container-based function extend the Dockerfile of your function image as follows:
    ```Dockerfile
    FROM docker.elastic.co/observability/apm-lambda-extension-{IMAGE_ARCH}:latest AS lambda-extension 
    FROM docker.elastic.co/observability/apm-agent-python:latest AS python-agent

    # FROM ...  <-- this is the base image of your Lambda function

    COPY --from=lambda-extension /opt/elastic-apm-extension /opt/extensions/elastic-apm-extension
    COPY --from=python-agent /opt/python/ /opt/python/

    # ...
    ```
  </tab-item>
</tab-set>


## Step 2: Configure APM on AWS Lambda

The Elastic APM AWS Lambda extension and the APM Python agent are configured through environment variables on the AWS Lambda function.
For the minimal configuration, you will need the *APM Server URL* to set the destination for APM data and an [APM Secret Token](https://www.elastic.co/docs/solutions/observability/apm/secret-token). If you prefer to use an [APM API key](https://www.elastic.co/docs/solutions/observability/apm/api-keys) instead of the APM secret token, use the `ELASTIC_APM_API_KEY` environment variable instead of `ELASTIC_APM_SECRET_TOKEN` in the following configuration.
For production environments, we recommend [using the AWS Secrets Manager to store your APM authentication key](https://www.elastic.co/docs/reference/apm/aws-lambda/aws-lambda-secrets-manager) instead of providing the secret value as plaintext in the environment variables.
<tab-set>
  <tab-item title="AWS Web Console">
    To configure APM through the AWS Management Console:
    1. Navigate to your function in the AWS Management Console
    2. Click on the *Configuration* tab
    3. Click on *Environment variables*
    4. Add the following required variables:

    ```bash
    AWS_LAMBDA_EXEC_WRAPPER       = /opt/python/bin/elasticapm-lambda  
    ELASTIC_APM_LAMBDA_APM_SERVER = <YOUR-APM-SERVER-URL>              
    ELASTIC_APM_SECRET_TOKEN      = <YOUR-APM-SECRET-TOKEN>            
    ELASTIC_APM_SEND_STRATEGY     = background                         
    ```
    ![Python environment variables configuration section in AWS Console](https://www.elastic.co/docs/reference/apm/agents/python/images/python-lambda-env-vars.png)
  </tab-item>

  <tab-item title="AWS CLI">
    To configure APM through the AWS command line interface execute the following command:
    ```bash
    aws lambda update-function-configuration --function-name yourLambdaFunctionName \
        --environment "Variables={AWS_LAMBDA_EXEC_WRAPPER=/opt/python/bin/elasticapm-lambda,ELASTIC_APM_LAMBDA_APM_SERVER=<YOUR-APM-SERVER-URL>,ELASTIC_APM_SECRET_TOKEN=<YOUR-APM-SECRET-TOKEN>,ELASTIC_APM_SEND_STRATEGY=background}" 
    ```
  </tab-item>

  <tab-item title="SAM">
    In your SAM `template.yml` file configure the following environment variables:
    ```yaml
    ...
    Resources:
      yourLambdaFunction:
        Type: AWS::Serverless::Function
        Properties:
          ...
          Environment:
              Variables:
                AWS_LAMBDA_EXEC_WRAPPER: /opt/python/bin/elasticapm-lambda
                ELASTIC_APM_LAMBDA_APM_SERVER: <YOUR-APM-SERVER-URL>
                ELASTIC_APM_SECRET_TOKEN: <YOUR-APM-SECRET-TOKEN>
                ELASTIC_APM_SEND_STRATEGY: background 
    ...
    ```
  </tab-item>

  <tab-item title="Serverless">
    In your `serverless.yml` file configure the following environment variables:
    ```yaml
    ...
    functions:
      yourLambdaFunction:
        ...
        environment:
          AWS_LAMBDA_EXEC_WRAPPER: /opt/python/bin/elasticapm-lambda
          ELASTIC_APM_LAMBDA_APM_SERVER: <YOUR-APM-SERVER-URL>
          ELASTIC_APM_SECRET_TOKEN: <YOUR-APM-SECRET-TOKEN>
          ELASTIC_APM_SEND_STRATEGY: background 
    ...
    ```
  </tab-item>

  <tab-item title="Terraform">
    In your Terraform file configure the following environment variables:
    ```yaml
    ...
    resource "aws_lambda_function" "your_lambda_function" {
      ...
      environment {
        variables = {
          AWS_LAMBDA_EXEC_WRAPPER       = /opt/python/bin/elasticapm-lambda
          ELASTIC_APM_LAMBDA_APM_SERVER = "<YOUR-APM-SERVER-URL>"
          ELASTIC_APM_SECRET_TOKEN      = "<YOUR-APM-SECRET-TOKEN>"
          ELASTIC_APM_SEND_STRATEGY     = "background" 
        }
      }
    }
    ...
    ```
  </tab-item>

  <tab-item title="Container Image">
    Environment variables configured for an AWS Lambda function are passed to the container running the lambda function. You can use one of the other options (through AWS Web Console, AWS CLI, etc.) to configure the following environment variables:
    ```bash
    AWS_LAMBDA_EXEC_WRAPPER       = /opt/python/bin/elasticapm-lambda  
    ELASTIC_APM_LAMBDA_APM_SERVER = <YOUR-APM-SERVER-URL>              
    ELASTIC_APM_SECRET_TOKEN      = <YOUR-APM-SECRET-TOKEN>            
    ELASTIC_APM_SEND_STRATEGY     = background                         
    ```
  </tab-item>
</tab-set>

You can optionally [fine-tune the Python agent](https://www.elastic.co/docs/reference/apm/agents/python/configuration) or the [configuration of the Elastic APM AWS Lambda extension](https://www.elastic.co/docs/reference/apm/aws-lambda/aws-lambda-config-options).
That’s it. After following the steps above, you’re ready to go!  Your Lambda function invocations should be traced from now on.  Spans will be captured for [supported technologies](https://www.elastic.co/docs/reference/apm/agents/python/supported-technologies). You can also use [`capture_span`](/docs/reference/apm/agents/python/api-reference#api-capture-span) to capture custom spans, and you can retrieve the `Client` object for capturing exceptions/messages using [`get_client`](/docs/reference/apm/agents/python/api-reference#api-get-client).