﻿---
title: Monitoring Azure Functions
description: You need an APM Server to which you can send APM data. Follow the APM Quick start if you have not set one up yet. For the best-possible performance, we...
url: https://www.elastic.co/docs/reference/apm/agents/python/azure-functions-support
products:
  - APM Agent
  - APM Python Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Python: Generally available
---

# Monitoring Azure Functions
## Prerequisites

You need an APM Server to which you can send APM data. Follow the [APM Quick start](https://www.elastic.co/docs/solutions/observability/apm/apm-server/fleet-managed) if you have not set one up yet. For the best-possible performance, we recommend setting up APM on Elastic Cloud in the same Azure region as your Azure Functions app.
<note>
  Currently, only HTTP and timer triggers are supported. Other trigger types may be captured as well, but the amount of captured contextual data may differ.
</note>


## Step 1: Enable Worker Extensions

Elastic APM uses [Worker Extensions](https://learn.microsoft.com/en-us/azure/azure-functions/functions-reference-python?tabs=asgi%2Capplication-level&pivots=python-mode-configuration#python-worker-extensions) to instrument Azure Functions. This feature is not enabled by default, and must be enabled in your Azure Functions App. Please follow the instructions in the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-reference-python?tabs=asgi%2Capplication-level&pivots=python-mode-configuration#using-extensions).
Once you have enabled Worker Extensions, these two lines of code will enable Elastic APM’s extension:
```python
from elasticapm.contrib.serverless.azure import ElasticAPMExtension

ElasticAPMExtension.configure()
```

Put them somewhere at the top of your Python file, before the function definitions.

## Step 2: Install the APM Python Agent

You need to add `elastic-apm` as a dependency for your Functions app. Simply add `elastic-apm` to your `requirements.txt` file. We recommend pinning the version to the current newest version of the agent, and periodically updating the version.

## Step 3: Configure APM on Azure Functions

The APM Python agent is configured through [App Settings](https://learn.microsoft.com/en-us/azure/azure-functions/functions-how-to-use-azure-function-app-settings?tabs=portal#settings). These are then picked up by the agent as environment variables.
For the minimal configuration, you will need the [`ELASTIC_APM_SERVER_URL`](/docs/reference/apm/agents/python/configuration#config-server-url) to set the destination for APM data and a [`ELASTIC_APM_SECRET_TOKEN`](/docs/reference/apm/agents/python/configuration#config-secret-token). If you prefer to use an [APM API key](https://www.elastic.co/docs/solutions/observability/apm/api-keys) instead of the APM secret token, use the [`ELASTIC_APM_API_KEY`](/docs/reference/apm/agents/python/configuration#config-api-key) environment variable instead of `ELASTIC_APM_SECRET_TOKEN` in the following example configuration.
```bash
$ az functionapp config appsettings set --settings ELASTIC_APM_SERVER_URL=https://example.apm.northeurope.azure.elastic-cloud.com:443
$ az functionapp config appsettings set --settings ELASTIC_APM_SECRET_TOKEN=verysecurerandomstring
```

You can optionally [fine-tune the Python agent](https://www.elastic.co/docs/reference/apm/agents/python/configuration).
That’s it; Once the agent is installed and working, spans will be captured for [supported technologies](https://www.elastic.co/docs/reference/apm/agents/python/supported-technologies). You can also use [`capture_span`](/docs/reference/apm/agents/python/api-reference#api-capture-span) to capture custom spans, and you can retrieve the `Client` object for capturing exceptions/messages using [`get_client`](/docs/reference/apm/agents/python/api-reference#api-get-client).