﻿---
title: APM Python agent
description: The Elastic APM Python agent sends performance metrics and error logs to the APM Server. It has built-in support for Django and Flask performance metrics...
url: https://www.elastic.co/docs/reference/apm/agents/python
products:
  - APM Agent
  - APM Python Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Python: Generally available
---

# APM Python agent
The Elastic APM Python agent sends performance metrics and error logs to the APM Server. It has built-in support for Django and Flask performance metrics and error logging, as well as generic support of other WSGI frameworks for error logging.

## How does the Agent work?

The Python Agent instruments your application to collect APM events in a few different ways:
To collect data about incoming requests and background tasks, the Agent integrates with [supported technologies](https://www.elastic.co/docs/reference/apm/agents/python/supported-technologies) to make use of hooks and signals provided by the framework. These framework integrations require limited code changes in your application.
To collect data from database drivers, HTTP libraries etc., we instrument certain functions and methods in these libraries. Instrumentations are set up automatically and do not require any code changes.
In addition to APM and error data, the Python agent also collects system and application metrics in regular intervals. This collection happens in a background thread that is started by the agent.
More detailed information on how the Agent works can be found in the [advanced topics](https://www.elastic.co/docs/reference/apm/agents/python/how-agent-works).

## Additional components

APM Agents work in conjunction with the [APM Server](https://www.elastic.co/docs/solutions/observability/apm), [Elasticsearch](https://www.elastic.co/docs/get-started/introduction#what-is-es), and [Kibana](https://www.elastic.co/docs/get-started/introduction#what-is-kib). The [APM documentation](https://www.elastic.co/docs/solutions/observability/apm) provides details on how these components work together, and provides a matrix outlining [Agent and Server compatibility](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility).

## Troubleshooting

If you're experiencing issues with the APM Python agent, refer to [Troubleshoot APM Python Agent](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-python/apm-python-agent).