﻿---
title: Set up the APM PHP Agent
description: We officially support Linux systems (glibc, deb and rpm packages) and Alpine Linux (musl libc - apk packages) for x86_64 (AMD64) processors. The agent...
url: https://www.elastic.co/docs/reference/apm/agents/php/set-up-apm-php-agent
products:
  - APM Agent
  - APM PHP Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for PHP: Generally available
---

# Set up the APM PHP Agent
## Prerequisites


### Operating system and architecture

We officially support Linux systems (glibc, deb and rpm packages) and Alpine Linux (musl libc - apk packages) for x86_64 (AMD64) processors.
<note>
  Experimentally, we also provide packages for the ARM64 architecture - please note that these packages have not been fully tested.
</note>


### PHP

The agent supports PHP versions 7.2-8.4.

### curl

The agent requires `libcurl` 7.58 or later.

## Installation

Install the agent using one of the [packages for supported platforms](https://github.com/elastic/apm-agent-php/releases/latest).

### Using RPM package (RHEL/CentOS, Fedora)

```bash
rpm -ivh <package-file>.rpm
```


### Using DEB package (Debian, Ubuntu 18+)

```bash
dpkg -i <package-file>.deb
```


### Using APK package (Alpine)

```bash
apk add --allow-untrusted <package-file>.apk
```


### Build from source

If you can’t find your distribution, you can install the agent by building it from the source. The following instructions will build the APM agent using the same docker environment that Elastic uses to build our official packages.
<note>
  The agent is currently only available for Linux operating system.
</note>

1. Download the agent source from [[https://github.com/elastic/apm-agent-php/](https://github.com/elastic/apm-agent-php/)](https://github.com/elastic/apm-agent-php/).
2. Execute the following commands to build the agent and install it:

```bash
cd apm-agent-php
# for linux glibc - libc distributions (Ubuntu, Redhat, etc)
export BUILD_ARCHITECTURE=linux-x86-64
# for linux with musl - libc distributions (Alpine)
export BUILD_ARCHITECTURE=linuxmusl-x86-64
# provide a path to php-config tool
export PHP_CONFIG=php-config

# build extensions
make -f .ci/Makefile build

# run extension tests
PHP_VERSION=`$PHP_CONFIG --version | cut -d'.' -f 1,2` make -f .ci/Makefile run-phpt-tests

# install agent extensions
sudo cp agent/native/_build/${BUILD_ARCHITECTURE}-release/ext/elastic_apm-*.so `$PHP_CONFIG --extension-dir`

# install automatic loader
sudo cp agent/native/_build/${BUILD_ARCHITECTURE}-release/loader/code/elastic_apm_loader.so `$PHP_CONFIG --extension-dir`
```

Enable the extension by adding the following to your `php.ini` file:
```ini
extension=elastic_apm_loader.so
elastic_apm.bootstrap_php_part_file=<repo root>/agent/php/bootstrap_php_part.php
```

To work, the agent needs both the built `elastic_apm-*.so` and the downloaded source files. So if you would like to build `elastic_apm-*.so` on one machine and then deploy it on a different machine, you will need to copy both the built `elastic_apm-*.so` and the downloaded source files.

## Limitations


### `open_basedir` PHP configuration option

Please be aware that if the [`open_basedir`](https://www.php.net/manual/en/ini.core.php#ini.open-basedir) option is configured in your php.ini, the installation directory of the agent (by default `/opt/elastic/apm-agent-php`) must be located within a path included in the [`open_basedir`](https://www.php.net/manual/en/ini.core.php#ini.open-basedir) value. Otherwise, the agent will not be loaded correctly.

### `Xdebug` stability and memory issues

We strongly advise against running the agent alongside the xdebug extension. Using both extensions simultaneously can lead to stability issues in the instrumented application, such as memory leaks. It is highly recommended to disable xdebug, preferably by preventing it from loading in the `php.ini` configuration file.

## Limitations

Please be aware that if the [open_basedir](https://www.php.net/manual/en/ini.core.php#ini.open-basedir) option is configured in your php.ini, the installation directory of the agent (by default /opt/elastic/apm-agent-php) must be located within a path included in the [open_basedir](https://www.php.net/manual/en/ini.core.php#ini.open-basedir) configuration. Otherwise, the agent will not be loaded correctly.