﻿---
title: Upgrading
description: The Elastic APM Node.js Agent uses semantic versioning, and therefore upgrades between minor versions of the agent, for example from 1.1 to 1.2, are always...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrading
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# Upgrading
The Elastic APM Node.js Agent uses [semantic versioning](https://semver.org/), and therefore upgrades between minor versions of the agent, for example from 1.1 to 1.2, are always backwards compatible. Upgrades that involve a major version bump often come with some backwards incompatible changes.
Before upgrading the agent, be sure to review the:
- [Node.js APM Agent release notes](https://www.elastic.co/docs/release-notes/apm/agents/nodejs)
- [APM Agent and Server compatibility chart](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-compatibility)

The following upgrade guides are available:
- [Upgrade to v4.x](https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v4) from version 3.x of the Elastic APM Node.js agent.
- [Upgrade to v3.x](https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v3) from version 2.x of the Elastic APM Node.js agent.
- [Upgrade to v2.x](https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v2) from version 1.x of the Elastic APM Node.js agent.
- [Upgrade to v1.x](https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v1) from version 0.x of the Elastic APM Node.js agent.


## End of life dates

We love all our products, but sometimes we must say goodbye to a release so that we can continue moving forward on future development and innovation. Our [End of life policy](https://www.elastic.co/support/eol) defines how long a given release is considered supported, as well as how long a release is considered still in active development or maintenance.