﻿---
title: Upgrade to v3.x
description: The following is a guide on upgrading your Node.js agent from version 2.x to version 3.x. Version 3.0.0 of the Node.js agent supports Node.js v8 (from...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v3
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# Upgrade to v3.x
The following is a guide on upgrading your Node.js agent from version 2.x to version 3.x.

## Overview

Version 3.0.0 of the Node.js agent supports Node.js v8 (from v8.6.0 and onwards), v10, and v12.

## Config options

The [`disableInstrumentations`](/docs/reference/apm/agents/nodejs/configuration#disable-instrumentations) config option now behaves differently if given the values `http` and/or `https`. Previously this would disable tracing of incoming and outgoing requests. Now this config option only deals with outgoing requests. To disable tracing of incoming http(s) requests, use the new [`instrumentIncomingHTTPRequests`](/docs/reference/apm/agents/nodejs/configuration#instrument-incoming-http-requests) config option.
It’s now possible to make use of manual instrumention while the [`instrument`](/docs/reference/apm/agents/nodejs/configuration#instrument) config option is set to `false`. This means that calls to for instance [`apm.startTransaction()`](/docs/reference/apm/agents/nodejs/agent-api#apm-start-transaction) or [`apm.startSpan()`](/docs/reference/apm/agents/nodejs/agent-api#apm-start-span) will produce transactions and spans even if `instrument` is set to `false`.

## API changes

The `type` associated with transactions and spans is no longer dot-separated. Instead the `type` property has been split into three distinct properties: `type`, `subtype`, and `action`. This has resulted in changes to the following API’s:
- [`apm.startTransaction()`](/docs/reference/apm/agents/nodejs/agent-api#apm-start-transaction): Function arguments changed
- [`apm.startSpan()`](/docs/reference/apm/agents/nodejs/agent-api#apm-start-span): Function arguments changed
- [`transaction.startSpan()`](/docs/reference/apm/agents/nodejs/transaction-api#transaction-start-span): Function arguments changed
- [`transaction.type`](/docs/reference/apm/agents/nodejs/transaction-api#transaction-type): String format changed
- [`span.type`](/docs/reference/apm/agents/nodejs/span-api#span-type): String format changed

The following deprecated API’s has been removed:
- `apm.setTag()`: Replaced by [`apm.setLabel()`](/docs/reference/apm/agents/nodejs/agent-api#apm-set-label)
- `apm.addTags()`: Replaced by [`apm.addLabels()`](/docs/reference/apm/agents/nodejs/agent-api#apm-add-labels)
- `transaction.setTag()`: Replaced by [`transaction.setLabel()`](/docs/reference/apm/agents/nodejs/transaction-api#transaction-set-label)
- `transaction.addTags()`: Replaced by [`transaction.addLabels()`](/docs/reference/apm/agents/nodejs/transaction-api#transaction-add-labels)
- `span.setTag()`: Replaced by [`span.setLabel()`](/docs/reference/apm/agents/nodejs/span-api#span-set-label)
- `span.addTags()`: Replaced by [`span.addLabels()`](/docs/reference/apm/agents/nodejs/span-api#span-add-labels)


## Changes in collected data

When instrumenting a GraphQL server that is run by [`apollo-server-express`](https://www.npmjs.com/package/apollo-server-express) the Transaction type is now `graphql` instead of `request`.
All Spans whose type was previously `ext` is now `external`.