﻿---
title: Upgrade to v1.x
description: The following is a guide on upgrading your Node.js agent from version 0.x to version 1.x. Version 1.x of the Node.js agent requires version 6.2 of the...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs/upgrade-to-v1
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# Upgrade to v1.x
The following is a guide on upgrading your Node.js agent from version 0.x to version 1.x.

## Overview

Version 1.x of the Node.js agent requires version 6.2 of the APM Server or higher.
The term "trace" was previously used to describe a small piece of work instrumented by the agent during a transaction. To align with modern APM vendors, we now refer to this as a "span"
The term "app" was previously used to describe your Node.js application in relation to Elastic APM. To be more specific, we now refer to this as a "service".

## Config options

The following config options have been removed in version 1.0.0:

|           |                                                                                                                                   |
|-----------|-----------------------------------------------------------------------------------------------------------------------------------|
| Name      | Note                                                                                                                              |
| `logBody` | Use [`captureBody`](/docs/reference/apm/agents/nodejs/configuration#capture-body) instead. Note that this option is not a boolean |

The following config options have been renamed between version 0.x and 1.x.
<note>
  The associated environment variable for each renamed config option have been renamed accordingly as well.
</note>


|                                   |                                                                                                                        |                                              |
|-----------------------------------|------------------------------------------------------------------------------------------------------------------------|----------------------------------------------|
| Old name                          | New name                                                                                                               | Note                                         |
| `appName`                         | [`serviceName`](/docs/reference/apm/agents/nodejs/configuration#service-name)                                          | Renamed to align with new naming conventions |
| `appVersion`                      | [`serviceVersion`](/docs/reference/apm/agents/nodejs/configuration#service-version)                                    | Renamed to align with new naming conventions |
| `captureTraceStackTrace`          | [`captureSpanStackTraces`](/docs/reference/apm/agents/nodejs/configuration#capture-span-stack-traces)                  | Renamed to align with new naming conventions |
| `sourceContextErrorAppFrames`     | [`sourceLinesErrorAppFrames`](/docs/reference/apm/agents/nodejs/configuration#source-context-error-app-frames)         | Renamed to align with other agents           |
| `sourceContextSpanAppFrames`      | [`sourceLinesSpanAppFrames`](/docs/reference/apm/agents/nodejs/configuration#source-context-span-app-frames)           | Renamed to align with other agents           |
| `sourceContextErrorLibraryFrames` | [`sourceLinesErrorLibraryFrames`](/docs/reference/apm/agents/nodejs/configuration#source-context-error-library-frames) | Renamed to align with other agents           |
| `sourceContextSpanLibraryFrames`  | [`sourceLinesSpanLibraryFrames`](/docs/reference/apm/agents/nodejs/configuration#source-context-span-library-frames)   | Renamed to align with other agents           |
| `validateServerCert`              | [`verifyServerCert`](/docs/reference/apm/agents/nodejs/configuration#validate-server-cert)                             | Renamed to align with other agents           |


## Agent API

The following functions have been renamed between version 0.x and 1.x:

|                |               |                                              |
|----------------|---------------|----------------------------------------------|
| Old name       | New name      | Note                                         |
| `buildTrace()` | `buildSpan()` | Renamed to align with new naming conventions |