﻿---
title: Set up the Agent
description: To get you off the ground, we’ve prepared guides for setting up the Agent with a few different popular web frameworks and technologies: Monitoring AWS...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs/set-up
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# Set up the Agent
To get you off the ground, we’ve prepared guides for setting up the Agent with a few different popular web frameworks and technologies:
- [Monitoring AWS Lambda Node.js Functions](https://www.elastic.co/docs/reference/apm/agents/nodejs/lambda)
- [Monitoring Node.js Azure Functions](https://www.elastic.co/docs/reference/apm/agents/nodejs/azure-functions)
- [Get started with Express](https://www.elastic.co/docs/reference/apm/agents/nodejs/express)
- [Get started with Fastify](https://www.elastic.co/docs/reference/apm/agents/nodejs/fastify)
- [Get started with hapi](https://www.elastic.co/docs/reference/apm/agents/nodejs/hapi)
- [Get started with Koa](https://www.elastic.co/docs/reference/apm/agents/nodejs/koa)
- [Get started with TypeScript](https://www.elastic.co/docs/reference/apm/agents/nodejs/typescript)

Alternatively, you can [Get started with a custom Node.js stack](https://www.elastic.co/docs/reference/apm/agents/nodejs/custom-stack). For Kubernetes, we support auto-attachment using the [APM attacher](https://www.elastic.co/docs/reference/apm/k8s-attacher).
To see an overview of which components of your application we instrument automatically, use the [*Supported technologies*](https://www.elastic.co/docs/reference/apm/agents/nodejs/supported-technologies) page.
Other useful documentation includes:
- [Starting the agent](https://www.elastic.co/docs/reference/apm/agents/nodejs/starting-agent)
- [*Configuration*](https://www.elastic.co/docs/reference/apm/agents/nodejs/advanced-setup)
- [*API Reference*](https://www.elastic.co/docs/reference/apm/agents/nodejs/api)
- [*Troubleshooting*](https://www.elastic.co/docs/troubleshoot/observability/apm-agent-nodejs/apm-nodejs-agent)