﻿---
title: Logs
description: The Elastic APM Node.js Agent provides support for Log correlation. When used together with the ecs-logging-nodejs packages, correlation IDs will be automatically...
url: https://www.elastic.co/docs/reference/apm/agents/nodejs/logs
products:
  - APM Agent
  - APM Node.js Agent
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Application Performance Monitoring Agent for Node.js: Generally available
---

# Logs
The Elastic APM Node.js Agent provides support for [Log correlation](#log-correlation-ids). When used together with the [`ecs-logging-nodejs` packages](https://www.elastic.co/docs/reference/ecs/logging/nodejs), correlation IDs will be automatically injected into log records to allow navigation between logs, traces, and services.
This feature is part of [Application log ingestion strategies](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs).

## Log correlation

[Log correlation](https://www.elastic.co/docs/solutions/observability/apm/logs) allows you to navigate to all logs belonging to a particular trace and vice-versa: for a specific log, see in which context it has been logged and which parameters the user provided.
In order to correlate logs from your application with traces captured by the Elastic APM Node.js Agent, your logs must contain the following identifiers:
- [`trace.id`](https://www.elastic.co/docs/reference/ecs/ecs-tracing)
- [`transaction.id`](https://www.elastic.co/docs/reference/ecs/ecs-tracing) or [`span.id`](https://www.elastic.co/docs/reference/ecs/ecs-tracing)

The APM Node.js Agent provides the [`apm.currentTraceIds`](/docs/reference/apm/agents/nodejs/agent-api#apm-current-trace-ids) API for this. If your application is also using one of the [ECS formatting plugin packages](https://www.elastic.co/docs/reference/ecs/logging/nodejs) (available for Pino, Winston, and Morgan), then this APM Agent API will automatically be used to inject the appropriate tracing fields into your log records. Otherwise, configure your logger to add these fields when emitting a log record.
When your logs contain the appropriate identifiers, the final step is to ingest them into the same Elasticsearch instance that contains your APM data. See [Ingest your logs into Elasticsearch](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs) for more information.